/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.video.mpeg;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;

public abstract class Box {
    public static HashMap<byte[], String> bytetoTypeMap = new HashMap();
    private long size;
    private String type;

    public Box(long size, String type) {
        this.size = size;
        this.type = type;
    }

    public long getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    protected String readType(DataInputStream in) throws IOException {
        byte[] buff = new byte[4];
        for (int i = 0; i < buff.length; ++i) {
            buff[i] = in.readByte();
        }
        return new String(buff);
    }

    protected String readText(DataInputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte b = 0;
        int count = 1;
        while ((b = in.readByte()) != 0) {
            ++count;
            bout.write(b);
        }
        System.out.println(count);
        return new String(bout.toByteArray(), "UTF-8");
    }

    protected byte[] read(DataInputStream in) throws IOException {
        byte[] buff = new byte[4];
        for (int i = 0; i < buff.length; ++i) {
            buff[i] = in.readByte();
        }
        return buff;
    }

    protected int read32(DataInputStream in) throws IOException {
        int output = in.readInt();
        return output;
    }

    protected long readU32(DataInputStream in) throws IOException {
        return (long)(in.read() << 24 | in.read() << 16 | in.read() << 8 | in.read()) & 0xFFFFFFFFL;
    }

    protected long readU64(DataInputStream fin) throws IOException {
        return this.readU32(fin) << 32 | this.readU32(fin);
    }

    protected int read24(DataInputStream fin) throws IOException {
        int output = 0;
        output = fin.read() << 16 | fin.read() << 8 | fin.read();
        return output;
    }

    protected int read16(DataInputStream fin) throws IOException {
        int output = 0;
        output = fin.read() << 8 | fin.read();
        return output;
    }

    protected double readFixedPoint1616(DataInputStream fin) throws IOException {
        double output = 0.0;
        int a = fin.readInt();
        output = (a >> 16) + (a & 0xFFFF) / 10;
        return output;
    }

    protected boolean comparebytes(byte[] arg1, byte[] arg2) {
        if (arg1.length != arg2.length) {
            return false;
        }
        for (int i = 0; i < arg1.length; ++i) {
            if (arg1[i] == arg2[i]) continue;
            return false;
        }
        return true;
    }

    protected abstract int load(DataInputStream var1) throws IOException;
}

