/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.video.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.restcomm.media.resource.player.video.mpeg.Box;
import org.restcomm.media.resource.player.video.mpeg.HandlerReferenceBox;
import org.restcomm.media.resource.player.video.mpeg.MediaHeaderBox;
import org.restcomm.media.resource.player.video.mpeg.MediaInformationBox;

public class MediaBox
extends Box {
    static byte[] TYPE = new byte[]{109, 100, 105, 97};
    static String TYPE_S = "mdia";
    private MediaHeaderBox mediaHeaderBox;
    private HandlerReferenceBox handlerReferenceBox;
    private MediaInformationBox mediaInformationBox;

    public MediaBox(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        int count = 8;
        long len = this.readU32(fin);
        byte[] type = this.read(fin);
        if (!this.comparebytes(type, MediaHeaderBox.TYPE)) {
            throw new IOException("Media header box is expected");
        }
        this.mediaHeaderBox = new MediaHeaderBox(len);
        count += this.mediaHeaderBox.load(fin);
        len = this.readU32(fin);
        type = this.read(fin);
        if (!this.comparebytes(type, HandlerReferenceBox.TYPE)) {
            throw new IOException("Handler box is mandatory");
        }
        this.handlerReferenceBox = new HandlerReferenceBox(len);
        count += this.handlerReferenceBox.load(fin);
        len = this.readU32(fin);
        type = this.read(fin);
        if (!this.comparebytes(type, MediaInformationBox.TYPE)) {
            throw new IOException("MediaInformationBox box is mandatory but received " + new String(type));
        }
        this.mediaInformationBox = new MediaInformationBox(len);
        count += this.mediaInformationBox.load(fin);
        return (int)this.getSize();
    }

    public MediaHeaderBox getMediaHeaderBox() {
        return this.mediaHeaderBox;
    }

    public HandlerReferenceBox getHandlerReferenceBox() {
        return this.handlerReferenceBox;
    }

    public MediaInformationBox getMediaInformationBox() {
        return this.mediaInformationBox;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

