/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.audio;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.restcomm.media.ComponentType;
import org.restcomm.media.component.AbstractSink;
import org.restcomm.media.component.AbstractSource;
import org.restcomm.media.component.audio.AudioInput;
import org.restcomm.media.resource.player.Track;
import org.restcomm.media.resource.player.audio.AudioPlayerEvent;
import org.restcomm.media.resource.player.audio.RemoteStreamProvider;
import org.restcomm.media.resource.player.audio.gsm.GsmTrackImpl;
import org.restcomm.media.resource.player.audio.mpeg.AMRTrackImpl;
import org.restcomm.media.resource.player.audio.tone.ToneTrackImpl;
import org.restcomm.media.resource.player.audio.tts.TtsTrackImpl;
import org.restcomm.media.resource.player.audio.wav.WavTrackImpl;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.spi.ResourceUnavailableException;
import org.restcomm.media.spi.dsp.Processor;
import org.restcomm.media.spi.format.AudioFormat;
import org.restcomm.media.spi.format.Format;
import org.restcomm.media.spi.format.FormatFactory;
import org.restcomm.media.spi.listener.Event;
import org.restcomm.media.spi.listener.Listener;
import org.restcomm.media.spi.listener.Listeners;
import org.restcomm.media.spi.listener.TooManyListenersException;
import org.restcomm.media.spi.memory.Frame;
import org.restcomm.media.spi.player.Player;
import org.restcomm.media.spi.player.PlayerListener;
import org.restcomm.media.spi.pooling.PooledObject;
import org.restcomm.media.spi.resource.TTSEngine;

public class AudioPlayerImpl
extends AbstractSource
implements Player,
TTSEngine,
PooledObject {
    private static final long serialVersionUID = 8321615909592642344L;
    private static final Logger log = Logger.getLogger(AudioPlayerImpl.class);
    private static final AudioFormat LINEAR = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private static final long period = 20000000L;
    private static final int packetSize = 20 * LINEAR.getSampleRate() / 1000 * LINEAR.getSampleSize() / 8;
    private Processor dsp;
    private final AudioInput input = new AudioInput(ComponentType.PLAYER.getType(), packetSize);
    private Track track;
    private int volume;
    private String voiceName = "kevin";
    private final Listeners<PlayerListener> listeners = new Listeners();
    private final RemoteStreamProvider remoteStreamProvider;

    public AudioPlayerImpl(String name, PriorityQueueScheduler scheduler, RemoteStreamProvider remoteStreamProvider) {
        super(name, scheduler, PriorityQueueScheduler.INPUT_QUEUE.intValue());
        this.connect((AbstractSink)this.input);
        this.remoteStreamProvider = remoteStreamProvider;
    }

    public AudioInput getAudioInput() {
        return this.input;
    }

    public void setDsp(Processor dsp) {
        this.dsp = dsp;
    }

    public Processor getDsp() {
        return this.dsp;
    }

    public void setURL(String passedURI) throws ResourceUnavailableException, MalformedURLException {
        block10: {
            if (this.track != null) {
                this.track.close();
                this.track = null;
            }
            if (!this.isConnected()) {
                throw new IllegalStateException("Component should be connected");
            }
            int pos = passedURI.lastIndexOf(46);
            if (pos == -1) {
                throw new MalformedURLException("Unknow file type: " + passedURI);
            }
            String ext = passedURI.substring(pos + 1).toLowerCase();
            URL targetURL = new URL(passedURI);
            try {
                if (ext.matches("wav")) {
                    this.track = new WavTrackImpl(targetURL, this.remoteStreamProvider);
                    break block10;
                }
                if (ext.matches("gsm")) {
                    this.track = new GsmTrackImpl(targetURL);
                    break block10;
                }
                if (ext.matches("tone")) {
                    this.track = new ToneTrackImpl(targetURL);
                    break block10;
                }
                if (ext.matches("txt")) {
                    this.track = new TtsTrackImpl(targetURL, this.voiceName, null);
                    break block10;
                }
                if (ext.matches("mov") || ext.matches("mp4") || ext.matches("3gp")) {
                    this.track = new AMRTrackImpl(targetURL);
                    break block10;
                }
                throw new ResourceUnavailableException("Unknown extension: " + passedURI);
            }
            catch (Exception e) {
                throw new ResourceUnavailableException((Throwable)e);
            }
        }
        this.duration = this.track.getDuration();
    }

    public void activate() {
        if (this.track == null) {
            throw new IllegalStateException("The media source is not specified");
        }
        this.start();
        this.listeners.dispatch((Event)new AudioPlayerEvent(this, 1));
    }

    public void deactivate() {
        this.stop();
        if (this.track != null) {
            this.track.close();
            this.track = null;
        }
    }

    protected void stopped() {
        this.listeners.dispatch((Event)new AudioPlayerEvent(this, 2));
    }

    protected void completed() {
        super.completed();
        this.listeners.dispatch((Event)new AudioPlayerEvent(this, 2));
    }

    public Frame evolve(long timestamp) {
        try {
            if (this.track == null) {
                return null;
            }
            Frame frame = this.track.process(timestamp);
            if (frame == null) {
                return null;
            }
            frame.setTimestamp(timestamp);
            if (frame.isEOM() && log.isInfoEnabled()) {
                log.info((Object)"End of file reached");
            }
            if (this.dsp != null) {
                try {
                    frame = this.dsp.process(frame, frame.getFormat(), (Format)LINEAR);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            if (frame.isEOM() && this.track != null) {
                this.track.close();
            }
            return frame;
        }
        catch (IOException e) {
            log.error((Object)e);
            if (this.track != null) {
                this.track.close();
            }
            return null;
        }
    }

    public void setVoiceName(String voiceName) {
        this.voiceName = voiceName;
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setText(String text) {
        this.track = new TtsTrackImpl(text, this.voiceName, null);
    }

    public void addListener(PlayerListener listener) throws TooManyListenersException {
        this.listeners.add((Listener)listener);
    }

    public void removeListener(PlayerListener listener) {
        this.listeners.remove((Listener)listener);
    }

    public void clearAllListeners() {
        this.listeners.clear();
    }

    public void checkIn() {
        this.clearAllListeners();
        this.track = null;
    }

    public void checkOut() {
    }
}

