/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.audio;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.restcomm.media.resource.player.audio.AudioPlayerImpl;
import org.restcomm.media.resource.player.audio.RemoteStreamProvider;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.spi.dsp.DspFactory;
import org.restcomm.media.spi.player.Player;
import org.restcomm.media.spi.player.PlayerProvider;

public class AudioPlayerProvider
implements PlayerProvider {
    private static final Logger log = Logger.getLogger(AudioPlayerProvider.class);
    private final PriorityQueueScheduler scheduler;
    private final RemoteStreamProvider remoteStreamProvider;
    private final AtomicInteger id;
    private DspFactory dsp;

    public AudioPlayerProvider(PriorityQueueScheduler scheduler, RemoteStreamProvider remoteStreamProvider, DspFactory dsp) {
        this.scheduler = scheduler;
        this.remoteStreamProvider = remoteStreamProvider;
        this.dsp = dsp;
        this.id = new AtomicInteger(0);
    }

    public Player provide() {
        AudioPlayerImpl player = new AudioPlayerImpl(this.nextId(), this.scheduler, this.remoteStreamProvider);
        try {
            player.setDsp(this.dsp.newProcessor());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.warn((Object)"Could not set DSP for newly provided Audio Player. Transcoding wont be possible!");
        }
        return player;
    }

    private String nextId() {
        return "audio-player" + this.id.getAndIncrement();
    }
}

