/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.audio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.sizeof.annotations.IgnoreSizeOf;
import org.restcomm.media.resource.player.audio.RemoteStreamProvider;

public class CachedRemoteStreamProvider
implements RemoteStreamProvider {
    private static final Logger log = Logger.getLogger(CachedRemoteStreamProvider.class);
    private CacheManager cacheManager;
    private ByteStreamCache.ISizeChangedListener sizeChangedListener;

    public CachedRemoteStreamProvider(int size) {
        log.info((Object)("Create AudioCache with size: " + size + "Mb"));
        this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache("preConfigured", CacheConfigurationBuilder.newCacheConfigurationBuilder(URL.class, ByteStreamCache.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)size, (ResourceUnit)MemoryUnit.MB)).build()).build(true);
        this.sizeChangedListener = new ByteStreamCache.ISizeChangedListener(){

            @Override
            public void onSizeChanged(URL uri, ByteStreamCache self) {
                log.debug((Object)("onSizeChanged for " + uri));
                CachedRemoteStreamProvider.this.getCache().put((Object)uri, (Object)self);
            }
        };
    }

    private Cache<URL, ByteStreamCache> getCache() {
        return this.cacheManager.getCache("preConfigured", URL.class, ByteStreamCache.class);
    }

    @Override
    public InputStream getStream(URL uri) throws IOException {
        ByteStreamCache exists;
        Cache<URL, ByteStreamCache> cache = this.getCache();
        ByteStreamCache stream = (ByteStreamCache)cache.get((Object)uri);
        if (stream == null && (exists = (ByteStreamCache)cache.putIfAbsent((Object)uri, (Object)(stream = new ByteStreamCache()))) != null) {
            stream = exists;
        }
        return new ByteArrayInputStream(stream.getBytes(uri, this.sizeChangedListener));
    }

    private static class ByteStreamCache {
        @IgnoreSizeOf
        private Lock lock = new ReentrantLock();
        private volatile byte[] bytes;

        private ByteStreamCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getBytes(URL uri, ISizeChangedListener listener) throws IOException {
            if (this.bytes == null) {
                this.lock.lock();
                try {
                    if (this.bytes == null) {
                        this.bytes = IOUtils.toByteArray((InputStream)uri.openStream());
                        listener.onSizeChanged(uri, this);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            return this.bytes;
        }

        static interface ISizeChangedListener {
            public void onSizeChanged(URL var1, ByteStreamCache var2);
        }
    }
}

