/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.audio;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.restcomm.media.resource.player.audio.AudioPlayerImpl;
import org.restcomm.media.resource.player.audio.RemoteStreamProvider;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.spi.dsp.DspFactory;
import org.restcomm.media.spi.pooling.PooledObjectFactory;

public class AudioPlayerFactory
implements PooledObjectFactory<AudioPlayerImpl> {
    private static final Logger log = Logger.getLogger(AudioPlayerImpl.class);
    private static final AtomicInteger ID = new AtomicInteger(1);
    private final PriorityQueueScheduler scheduler;
    private final DspFactory dspFactory;
    private final RemoteStreamProvider remoteStreamProvider;

    public AudioPlayerFactory(PriorityQueueScheduler scheduler, DspFactory dspFactory, RemoteStreamProvider remoteStreamProvider) {
        this.scheduler = scheduler;
        this.dspFactory = dspFactory;
        this.remoteStreamProvider = remoteStreamProvider;
    }

    public AudioPlayerImpl produce() {
        AudioPlayerImpl player = new AudioPlayerImpl("player-" + ID.getAndIncrement(), this.scheduler, this.remoteStreamProvider);
        try {
            player.setDsp(this.dspFactory.newProcessor());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error((Object)"Could not set DSP for Audio Player", (Throwable)e);
        }
        return player;
    }
}

