/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.audio.tts;

import com.sun.speech.freetts.Voice;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.restcomm.media.resource.player.audio.tts.AlanVoiceFactory;
import org.restcomm.media.resource.player.audio.tts.KevinVoiceFactory;
import org.restcomm.media.resource.player.audio.tts.MbrolaVoiceFactory;
import org.restcomm.media.resource.player.audio.tts.VoiceFactory;

public class VoiceManager {
    private static final Logger logger = Logger.getLogger(VoiceManager.class);
    private static final VoiceManager INSTANCE = new VoiceManager();
    private HashMap<String, VoiceFactory> voiceFactories = new HashMap();

    private VoiceManager() {
        this.setupKevin();
        this.setupAlan();
        this.setupMbrola();
        if (logger.isInfoEnabled()) {
            StringBuffer b = new StringBuffer();
            for (String name : this.voiceFactories.keySet()) {
                b.append(name);
                b.append(", ");
            }
            logger.info((Object)("Available voices for TTS are : " + b.toString()));
        }
    }

    private void setupKevin() {
        Voice[] voices;
        KevinVoiceFactory kevinVoiceFactory = new KevinVoiceFactory();
        for (Voice v : voices = kevinVoiceFactory.getVoices()) {
            this.voiceFactories.put(v.getName(), kevinVoiceFactory);
        }
    }

    private void setupAlan() {
        Voice[] voices;
        AlanVoiceFactory alanVoiceFactory = new AlanVoiceFactory();
        for (Voice v : voices = alanVoiceFactory.getVoices()) {
            this.voiceFactories.put(v.getName(), alanVoiceFactory);
        }
    }

    private void setupMbrola() {
        Voice[] voices;
        MbrolaVoiceFactory mbrolaVoiceFactory = new MbrolaVoiceFactory();
        for (Voice v : voices = mbrolaVoiceFactory.getVoices()) {
            this.voiceFactories.put(v.getName(), mbrolaVoiceFactory);
        }
    }

    public static VoiceManager getInstance() {
        return INSTANCE;
    }

    public Voice getVoice(String voiceName) {
        Voice voice = null;
        VoiceFactory voiceFactory = this.voiceFactories.get(voiceName);
        if (voiceFactory != null) {
            voice = voiceFactory.getVoice(voiceName);
        }
        return voice;
    }
}

