/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.video.mpeg;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.restcomm.media.resource.player.video.mpeg.AudioTrack;
import org.restcomm.media.resource.player.video.mpeg.Box;
import org.restcomm.media.resource.player.video.mpeg.FileTypeBox;
import org.restcomm.media.resource.player.video.mpeg.FreeSpaceBox;
import org.restcomm.media.resource.player.video.mpeg.HintTrackReferenceTypeBox;
import org.restcomm.media.resource.player.video.mpeg.MediaDataBox;
import org.restcomm.media.resource.player.video.mpeg.MovieBox;
import org.restcomm.media.resource.player.video.mpeg.RTPTrackSdpHintInformation;
import org.restcomm.media.resource.player.video.mpeg.TrackBox;
import org.restcomm.media.resource.player.video.mpeg.TrackHintInformation;
import org.restcomm.media.resource.player.video.mpeg.TrackReferenceBox;
import org.restcomm.media.resource.player.video.mpeg.TrackReferenceTypeBox;
import org.restcomm.media.resource.player.video.mpeg.VideoTrack;
import org.restcomm.media.spi.format.Format;

public class MpegPresentation {
    private FileTypeBox fileTypeBox;
    private MovieBox movieBox;
    private MediaDataBox mediaDataBox;
    private volatile TrackBox audioTrackBox = null;
    private volatile TrackBox audioHintTrackBox = null;
    private volatile TrackBox videoTrackBox = null;
    private volatile TrackBox videoHintTrackBox = null;
    private AudioTrack audioTrack;
    private VideoTrack videoTrack;
    private Format audioForamt = null;
    private Format videFormat = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MpegPresentation(URL url) throws IOException {
        File file = new File(url.getPath());
        InputStream input = url.openStream();
        DataInputStream ds = new DataInputStream(input);
        try {
            this.parseFile(ds);
            this.prepareTracks();
            if (this.audioTrackBox != null && this.audioHintTrackBox != null) {
                this.audioTrack = new AudioTrack(this.audioTrackBox, this.audioHintTrackBox, file);
            }
            if (this.videoTrackBox != null && this.videoHintTrackBox != null) {
                this.videoTrack = new VideoTrack(this.videoTrackBox, this.videoHintTrackBox, file);
            }
        }
        finally {
            ds.close();
            input.close();
        }
    }

    public AudioTrack getAudioTrack() {
        return this.audioTrack;
    }

    public VideoTrack getVideoTrack() {
        return this.videoTrack;
    }

    public Format getAudioForamt() {
        return this.audioForamt;
    }

    public Format getVideFormat() {
        return this.videFormat;
    }

    public void prepareTracks() {
        for (TrackBox tBox : this.movieBox.getTrackBoxes()) {
            String type = tBox.getMediaBox().getHandlerReferenceBox().getHandlerType();
            if (type.equalsIgnoreCase("soun")) {
                this.audioTrackBox = tBox;
                continue;
            }
            if (type.equalsIgnoreCase("vide")) {
                this.videoTrackBox = tBox;
                continue;
            }
            if (!type.equalsIgnoreCase("hint")) continue;
            TrackReferenceBox trackReferenceBox = tBox.getTrackReferenceBox();
            List<TrackReferenceTypeBox> trackRefTypList = trackReferenceBox.getTrackReferenceTypeBoxes();
            for (TrackReferenceTypeBox trkRefTypBox : trackRefTypList) {
                if (!trkRefTypBox.getType().equals(HintTrackReferenceTypeBox.TYPE_S)) continue;
                long[] trackIds = trkRefTypBox.getTrackIDs();
                long trackId = trackIds[0];
                if (this.audioTrackBox.getTrackHeaderBox().getTrackID() == trackId) {
                    this.audioHintTrackBox = tBox;
                    for (Box b : this.audioHintTrackBox.getUserDataBox().getUserDefinedBoxes()) {
                        TrackHintInformation trackHintInfBox;
                        RTPTrackSdpHintInformation rtpTrackSdpHintInf;
                        if (b.getType().compareTo(TrackHintInformation.TYPE_S) != 0 || (rtpTrackSdpHintInf = (trackHintInfBox = (TrackHintInformation)b).getRtpTrackSdpHintInformation()) == null) continue;
                        String sdp = rtpTrackSdpHintInf.getSdpText();
                    }
                    continue;
                }
                if (this.videoTrackBox.getTrackHeaderBox().getTrackID() != trackId) continue;
                this.videoHintTrackBox = tBox;
            }
        }
    }

    private void parseFile(DataInputStream ds) throws IOException {
        long count = 0L;
        while (ds.available() > 0) {
            long len = this.readU32(ds);
            byte[] type = this.read(ds);
            if (this.comparebytes(type, FileTypeBox.TYPE)) {
                this.fileTypeBox = new FileTypeBox(len);
                count += (long)this.fileTypeBox.load(ds);
                continue;
            }
            if (this.comparebytes(type, MovieBox.TYPE)) {
                this.movieBox = new MovieBox(len);
                count += (long)this.movieBox.load(ds);
                continue;
            }
            if (this.comparebytes(type, FreeSpaceBox.TYPE_FREE)) {
                FreeSpaceBox free = new FreeSpaceBox(len, FreeSpaceBox.TYPE_FREE_S);
                count += (long)free.load(ds);
                continue;
            }
            if (this.comparebytes(type, FreeSpaceBox.TYPE_SKIP)) {
                FreeSpaceBox skip = new FreeSpaceBox(len, FreeSpaceBox.TYPE_SKIP_S);
                count += (long)skip.load(ds);
                continue;
            }
            if (this.comparebytes(type, MediaDataBox.TYPE)) {
                this.mediaDataBox = new MediaDataBox(len);
                count += (long)this.mediaDataBox.load(ds);
                continue;
            }
            if (len - 8L <= 0L) continue;
            ds.skipBytes((int)len - 8);
        }
    }

    private byte[] read(DataInputStream in) throws IOException {
        byte[] buff = new byte[4];
        for (int i = 0; i < buff.length; ++i) {
            buff[i] = in.readByte();
        }
        return buff;
    }

    private boolean comparebytes(byte[] arg1, byte[] arg2) {
        if (arg1.length != arg2.length) {
            return false;
        }
        for (int i = 0; i < arg1.length; ++i) {
            if (arg1[i] == arg2[i]) continue;
            return false;
        }
        return true;
    }

    private long readU32(DataInputStream in) throws IOException {
        return (long)(in.read() << 24 | in.read() << 16 | in.read() << 8 | in.read()) & 0xFFFFFFFFL;
    }

    public void close() {
        if (this.audioTrack != null) {
            this.audioTrack.close();
            this.audioTrack = null;
        }
        if (this.videoTrack != null) {
            this.videoTrack.close();
            this.videoTrack = null;
        }
    }
}

