/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.video.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.restcomm.media.resource.player.video.mpeg.FullBox;

public class SampleSizeBox
extends FullBox {
    static byte[] TYPE = new byte[]{115, 116, 115, 122};
    static String TYPE_S = "stsz";
    private long sampleSize;
    private long sampleCount;
    private long[] entrySize;

    public SampleSizeBox(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        super.load(fin);
        this.sampleSize = this.readU32(fin);
        this.sampleCount = this.readU32(fin);
        if (this.sampleSize == 0L) {
            this.entrySize = new long[(int)this.sampleCount];
            int i = 0;
            while ((long)i < this.sampleCount) {
                this.entrySize[i] = this.readU32(fin);
                ++i;
            }
        }
        return (int)this.getSize();
    }

    public long getSampleSize() {
        return this.sampleSize;
    }

    public long getSampleCount() {
        return this.sampleCount;
    }

    public long[] getEntrySize() {
        return this.entrySize;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

