/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.video.mpeg;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.restcomm.media.resource.player.video.mpeg.RTPConstructor;

public class RTPSampleConstructor
extends RTPConstructor {
    public static final int TYPE = 2;
    private byte trackRefIndex;
    private int length;
    private long sampleNumber;
    private long sampleOffSet;
    private int bytesPerBlock = 1;
    private int samplesPerBlock = 1;

    public RTPSampleConstructor() {
        super(2);
    }

    @Override
    public int load(RandomAccessFile raAccFile) throws IOException {
        this.trackRefIndex = raAccFile.readByte();
        this.length = raAccFile.read() << 8 | raAccFile.read();
        this.sampleNumber = (long)(raAccFile.read() << 24 | raAccFile.read() << 16 | raAccFile.read() << 8 | raAccFile.read()) & 0xFFFFFFFFL;
        this.sampleOffSet = (long)(raAccFile.read() << 24 | raAccFile.read() << 16 | raAccFile.read() << 8 | raAccFile.read()) & 0xFFFFFFFFL;
        this.bytesPerBlock = raAccFile.read() << 8 | raAccFile.read();
        this.samplesPerBlock = raAccFile.read() << 8 | raAccFile.read();
        return 16;
    }

    public int getTrackRefIndex() {
        return this.trackRefIndex;
    }

    public int getLength() {
        return this.length;
    }

    public long getSampleNumber() {
        return this.sampleNumber;
    }

    public long getSampleOffSet() {
        return this.sampleOffSet;
    }

    public int getBytesPerBlock() {
        return this.bytesPerBlock;
    }

    public int getSamplesPerBlock() {
        return this.samplesPerBlock;
    }
}

