/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.video.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.restcomm.media.resource.player.video.mpeg.AMRSampleEntry;
import org.restcomm.media.resource.player.video.mpeg.AMRWidebandSampleEntry;
import org.restcomm.media.resource.player.video.mpeg.FullBox;
import org.restcomm.media.resource.player.video.mpeg.MP4AudioSampleEntry;
import org.restcomm.media.resource.player.video.mpeg.RtpHintSampleEntry;
import org.restcomm.media.resource.player.video.mpeg.SampleEntry;
import org.restcomm.media.resource.player.video.mpeg.UndefinedBox;
import org.restcomm.media.resource.player.video.mpeg.VisualSampleEntry;

public class SampleDescriptionBox
extends FullBox {
    static byte[] TYPE = new byte[]{115, 116, 115, 100};
    static String TYPE_S = "stsd";
    private SampleEntry[] sampleEntries = null;

    public SampleDescriptionBox(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        super.load(fin);
        long entryCount = this.readU32(fin);
        this.sampleEntries = new SampleEntry[(int)entryCount];
        int i = 0;
        while ((long)i < entryCount) {
            long len1 = this.readU32(fin);
            byte[] type = this.read(fin);
            SampleEntry sampleEntry = null;
            if (this.comparebytes(type, AMRSampleEntry.TYPE)) {
                sampleEntry = new AMRSampleEntry(len1);
                sampleEntry.load(fin);
            } else if (this.comparebytes(type, AMRWidebandSampleEntry.TYPE)) {
                sampleEntry = new AMRWidebandSampleEntry(len1);
                sampleEntry.load(fin);
            } else if (this.comparebytes(type, MP4AudioSampleEntry.TYPE)) {
                sampleEntry = new MP4AudioSampleEntry(len1);
                sampleEntry.load(fin);
            } else if (this.comparebytes(type, VisualSampleEntry.TYPE)) {
                sampleEntry = new VisualSampleEntry(len1);
                sampleEntry.load(fin);
            } else if (this.comparebytes(type, RtpHintSampleEntry.TYPE)) {
                sampleEntry = new RtpHintSampleEntry(len1);
                sampleEntry.load(fin);
            } else {
                UndefinedBox undefinedBox = new UndefinedBox(len1, new String(type));
                undefinedBox.load(fin);
            }
            this.sampleEntries[i] = sampleEntry;
            ++i;
        }
        return (int)this.getSize();
    }

    public SampleEntry[] getSampleEntries() {
        return this.sampleEntries;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

