/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.video.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.restcomm.media.resource.player.video.mpeg.Box;
import org.restcomm.media.resource.player.video.mpeg.EditBox;
import org.restcomm.media.resource.player.video.mpeg.MediaBox;
import org.restcomm.media.resource.player.video.mpeg.TrackHeaderBox;
import org.restcomm.media.resource.player.video.mpeg.TrackReferenceBox;
import org.restcomm.media.resource.player.video.mpeg.UserDataBox;

public class TrackBox
extends Box {
    static byte[] TYPE = new byte[]{116, 114, 97, 107};
    static String TYPE_S = "trak";
    private TrackHeaderBox trackHeaderBox;
    private EditBox editBox;
    private MediaBox mediaBox;
    private TrackReferenceBox trackReferenceBox;
    private UserDataBox userDataBox;

    public TrackBox(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        int count = 8;
        long len = this.readU32(fin);
        byte[] type = this.read(fin);
        if (!this.comparebytes(type, TrackHeaderBox.TYPE)) {
            throw new IOException("Track header expected");
        }
        this.trackHeaderBox = new TrackHeaderBox(len);
        count += this.trackHeaderBox.load(fin);
        while ((long)count < this.getSize()) {
            len = this.readU32(fin);
            type = this.read(fin);
            if (this.comparebytes(type, EditBox.TYPE)) {
                this.editBox = new EditBox(len);
                count += this.editBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, MediaBox.TYPE)) {
                this.mediaBox = new MediaBox(len);
                count += this.mediaBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, TrackReferenceBox.TYPE)) {
                this.trackReferenceBox = new TrackReferenceBox(len);
                count += this.trackReferenceBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, UserDataBox.TYPE)) {
                this.userDataBox = new UserDataBox(len, true);
                count += this.userDataBox.load(fin);
                continue;
            }
            throw new IOException("Unknown box=" + new String(type) + " Parent = TrackBox");
        }
        return (int)this.getSize();
    }

    public TrackHeaderBox getTrackHeaderBox() {
        return this.trackHeaderBox;
    }

    public EditBox getEditBox() {
        return this.editBox;
    }

    public MediaBox getMediaBox() {
        return this.mediaBox;
    }

    public TrackReferenceBox getTrackReferenceBox() {
        return this.trackReferenceBox;
    }

    public UserDataBox getUserDataBox() {
        return this.userDataBox;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

