/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.video.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restcomm.media.resource.player.video.mpeg.Box;
import org.restcomm.media.resource.player.video.mpeg.CdscTrackReferenceTypeBox;
import org.restcomm.media.resource.player.video.mpeg.HintTrackReferenceTypeBox;
import org.restcomm.media.resource.player.video.mpeg.TrackReferenceTypeBox;

public class TrackReferenceBox
extends Box {
    static byte[] TYPE = new byte[]{116, 114, 101, 102};
    static String TYPE_S = "tref";
    private List<TrackReferenceTypeBox> trackReferenceTypeBoxes = new ArrayList<TrackReferenceTypeBox>();

    public TrackReferenceBox(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        int count = 8;
        while ((long)count < this.getSize()) {
            TrackReferenceTypeBox typeRefBox = null;
            long len = this.readU32(fin);
            byte[] type = this.read(fin);
            if (this.comparebytes(type, HintTrackReferenceTypeBox.TYPE)) {
                typeRefBox = new HintTrackReferenceTypeBox(len);
                count += typeRefBox.load(fin);
            } else if (this.comparebytes(type, CdscTrackReferenceTypeBox.TYPE)) {
                typeRefBox = new CdscTrackReferenceTypeBox(len);
                count += typeRefBox.load(fin);
            } else {
                throw new IOException("Unknown box=" + new String(type));
            }
            this.trackReferenceTypeBoxes.add(typeRefBox);
        }
        return (int)this.getSize();
    }

    public List<TrackReferenceTypeBox> getTrackReferenceTypeBoxes() {
        return this.trackReferenceTypeBoxes;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

