/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.attributes.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.attributes.SsrcAttribute;

public class SsrcAttributeParser
implements SdpParser<SsrcAttribute> {
    private static final String REGEX = "^a=ssrc:\\S+\\s\\w+(:\\S+)?$";
    private static final Pattern PATTERN = Pattern.compile("^a=ssrc:\\S+\\s\\w+(:\\S+)?$");
    private static final String COLON = ":";
    private static final String WHITESPACE = " ";

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public SsrcAttribute parse(String sdp) throws SdpException {
        try {
            String[] values = sdp.trim().substring(7).split(WHITESPACE);
            int separator = values[1].indexOf(COLON);
            String attName = separator == -1 ? values[1] : values[1].substring(0, separator);
            String attValue = separator == -1 ? null : values[1].substring(separator + 1);
            SsrcAttribute ssrc = new SsrcAttribute(values[0]);
            ssrc.addAttribute(attName, attValue);
            return ssrc;
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(SsrcAttribute field, String sdp) throws SdpException {
        try {
            String attValue;
            String[] values = sdp.trim().substring(7).split(WHITESPACE);
            int separator = values[1].indexOf(COLON);
            String attName = separator == -1 ? values[1] : values[1].substring(0, separator);
            String string = attValue = separator == -1 ? null : values[1].substring(separator + 1);
            if (!field.getSsrcId().equals(values[0])) {
                field.reset();
                field.setSsrcId(values[0]);
            }
            field.addAttribute(attName, attValue);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: ", e);
        }
    }
}

