/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp;

import java.util.HashMap;
import java.util.Map;
import org.restcomm.media.sdp.SdpField;
import org.restcomm.media.sdp.SessionLevelAccessor;
import org.restcomm.media.sdp.attributes.ConnectionModeAttribute;
import org.restcomm.media.sdp.dtls.attributes.FingerprintAttribute;
import org.restcomm.media.sdp.dtls.attributes.SetupAttribute;
import org.restcomm.media.sdp.fields.ConnectionField;
import org.restcomm.media.sdp.fields.MediaDescriptionField;
import org.restcomm.media.sdp.fields.OriginField;
import org.restcomm.media.sdp.fields.SessionNameField;
import org.restcomm.media.sdp.fields.TimingField;
import org.restcomm.media.sdp.fields.VersionField;
import org.restcomm.media.sdp.ice.attributes.IceLiteAttribute;
import org.restcomm.media.sdp.ice.attributes.IcePwdAttribute;
import org.restcomm.media.sdp.ice.attributes.IceUfragAttribute;

public class SessionDescription
implements SessionLevelAccessor {
    private static final String NEWLINE = "\n";
    private final StringBuilder builder = new StringBuilder();
    private VersionField version;
    private OriginField origin;
    private SessionNameField sessionName;
    private ConnectionField connection;
    private TimingField timing;
    private ConnectionModeAttribute connectionMode;
    private IceLiteAttribute iceLite;
    private IcePwdAttribute icePwd;
    private IceUfragAttribute iceUfrag;
    private FingerprintAttribute fingerprint;
    private SetupAttribute setup;
    private final Map<String, MediaDescriptionField> mediaMap = new HashMap<String, MediaDescriptionField>(5);

    public VersionField getVersion() {
        return this.version;
    }

    public void setVersion(VersionField version) {
        this.version = version;
    }

    public OriginField getOrigin() {
        return this.origin;
    }

    public void setOrigin(OriginField origin) {
        this.origin = origin;
    }

    public SessionNameField getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(SessionNameField sessionName) {
        this.sessionName = sessionName;
    }

    @Override
    public ConnectionField getConnection() {
        return this.connection;
    }

    public ConnectionField getConnection(String media) {
        ConnectionField mediaConn;
        if (this.mediaMap.containsKey(media) && (mediaConn = this.mediaMap.get(media).getConnection()) != null) {
            return mediaConn;
        }
        return this.connection;
    }

    public void setConnection(ConnectionField connection) {
        this.connection = connection;
    }

    public TimingField getTiming() {
        return this.timing;
    }

    public void setTiming(TimingField timing) {
        this.timing = timing;
    }

    @Override
    public ConnectionModeAttribute getConnectionMode() {
        return this.connectionMode;
    }

    public ConnectionModeAttribute getConnectionMode(String media) {
        ConnectionModeAttribute connectionMode;
        if (this.mediaMap.containsKey(media) && (connectionMode = this.mediaMap.get(media).getConnectionMode()) != null) {
            return connectionMode;
        }
        return this.connectionMode;
    }

    public void setConnectionMode(ConnectionModeAttribute connectionMode) {
        this.connectionMode = connectionMode;
    }

    public IceLiteAttribute getIceLite() {
        return this.iceLite;
    }

    public void setIceLite(IceLiteAttribute iceLite) {
        this.iceLite = iceLite;
    }

    @Override
    public IcePwdAttribute getIcePwd() {
        return this.icePwd;
    }

    public void setIcePwd(IcePwdAttribute icePwd) {
        this.icePwd = icePwd;
    }

    @Override
    public IceUfragAttribute getIceUfrag() {
        return this.iceUfrag;
    }

    public void setIceUfrag(IceUfragAttribute iceUfrag) {
        this.iceUfrag = iceUfrag;
    }

    @Override
    public FingerprintAttribute getFingerprint() {
        return this.fingerprint;
    }

    public FingerprintAttribute getFingerprint(String media) {
        FingerprintAttribute audioFingerprint;
        if (this.mediaMap.containsKey(media) && (audioFingerprint = this.mediaMap.get(media).getFingerprint()) != null) {
            return audioFingerprint;
        }
        return this.fingerprint;
    }

    @Override
    public SetupAttribute getSetup() {
        return this.setup;
    }

    public SetupAttribute getSetupAttribute(String media) {
        SetupAttribute setup;
        if (this.mediaMap.containsKey(media) && (setup = this.mediaMap.get(media).getSetup()) != null) {
            return setup;
        }
        return this.setup;
    }

    public void setSetup(SetupAttribute setup) {
        this.setup = setup;
    }

    public void setFingerprint(FingerprintAttribute fingerprint) {
        this.fingerprint = fingerprint;
    }

    public MediaDescriptionField getMediaDescription(String mediaType) {
        return this.mediaMap.get(mediaType);
    }

    public boolean containsMediaDescription(String mediaType) {
        return this.mediaMap.containsKey(mediaType);
    }

    public void addMediaDescription(MediaDescriptionField media) {
        this.mediaMap.put(media.getMedia(), media);
    }

    public boolean containsIce() {
        if (this.iceLite != null || this.iceUfrag != null || this.icePwd != null) {
            return true;
        }
        if (!this.mediaMap.isEmpty()) {
            for (MediaDescriptionField media : this.mediaMap.values()) {
                if (!media.containsIce()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsDtls() {
        if (this.fingerprint != null) {
            return true;
        }
        if (!this.mediaMap.isEmpty()) {
            for (MediaDescriptionField media : this.mediaMap.values()) {
                if (!media.containsDtls()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        this.builder.setLength(0);
        this.append(this.version);
        this.append(this.origin);
        this.append(this.sessionName);
        this.append(this.connection);
        this.append(this.timing);
        this.append(this.iceLite);
        this.append(this.iceUfrag);
        this.append(this.icePwd);
        this.append(this.fingerprint);
        this.append(this.setup);
        for (MediaDescriptionField media : this.mediaMap.values()) {
            this.append(media);
        }
        this.builder.deleteCharAt(this.builder.length() - 1);
        return this.builder.toString();
    }

    private void append(SdpField field) {
        if (field != null) {
            this.builder.append(field.toString()).append(NEWLINE);
        }
    }
}

