/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.fields;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restcomm.media.sdp.MediaProfile;
import org.restcomm.media.sdp.SdpField;
import org.restcomm.media.sdp.SessionLevelAccessor;
import org.restcomm.media.sdp.attributes.ConnectionModeAttribute;
import org.restcomm.media.sdp.attributes.FormatParameterAttribute;
import org.restcomm.media.sdp.attributes.MaxPacketTimeAttribute;
import org.restcomm.media.sdp.attributes.PacketTimeAttribute;
import org.restcomm.media.sdp.attributes.RtpMapAttribute;
import org.restcomm.media.sdp.attributes.SsrcAttribute;
import org.restcomm.media.sdp.dtls.attributes.FingerprintAttribute;
import org.restcomm.media.sdp.dtls.attributes.SetupAttribute;
import org.restcomm.media.sdp.fields.ConnectionField;
import org.restcomm.media.sdp.ice.attributes.CandidateAttribute;
import org.restcomm.media.sdp.ice.attributes.IcePwdAttribute;
import org.restcomm.media.sdp.ice.attributes.IceUfragAttribute;
import org.restcomm.media.sdp.rtcp.attributes.RtcpAttribute;
import org.restcomm.media.sdp.rtcp.attributes.RtcpMuxAttribute;

public class MediaDescriptionField
implements SdpField {
    private static final String NEWLINE = "\n";
    public static final char FIELD_TYPE = 'm';
    private static final String BEGIN = "m=";
    private SessionLevelAccessor session;
    private String media;
    private int port;
    private String protocol;
    private final List<Integer> payloadTypes;
    private final Map<Integer, RtpMapAttribute> formats;
    private ConnectionField connection;
    private ConnectionModeAttribute connectionMode;
    private RtcpAttribute rtcp;
    private RtcpMuxAttribute rtcpMux;
    private SsrcAttribute ssrc;
    private PacketTimeAttribute ptime;
    private MaxPacketTimeAttribute maxptime;
    private IcePwdAttribute icePwd;
    private IceUfragAttribute iceUfrag;
    private List<CandidateAttribute> candidates;
    private FingerprintAttribute fingerprint;
    private SetupAttribute setup;
    private final StringBuilder builder;

    public MediaDescriptionField() {
        this(null);
    }

    public MediaDescriptionField(SessionLevelAccessor sessionAccessor) {
        this.session = sessionAccessor;
        this.builder = new StringBuilder(BEGIN);
        this.payloadTypes = new ArrayList<Integer>(10);
        this.formats = new HashMap<Integer, RtpMapAttribute>(10);
    }

    public void setSession(SessionLevelAccessor session) {
        this.session = session;
    }

    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void addPayloadType(int payloadType) {
        if (!this.payloadTypes.contains(payloadType)) {
            this.payloadTypes.add(payloadType);
        }
    }

    public void setPayloadTypes(int ... payloadTypes) {
        this.payloadTypes.clear();
        for (int payloadType : payloadTypes) {
            this.addPayloadType(payloadType);
        }
    }

    public boolean containsPayloadType(int payloadType) {
        return this.payloadTypes.contains(payloadType);
    }

    public void setFormats(RtpMapAttribute ... formats) {
        this.formats.clear();
        int numFormats = formats.length;
        for (int i = 0; i < numFormats; ++i) {
            this.addFormat(formats[i]);
        }
    }

    public void addFormat(RtpMapAttribute format) {
        this.formats.put(format.getPayloadType(), format);
    }

    public void addFormats(RtpMapAttribute ... formats) {
        int numFormats = formats.length;
        for (int i = 0; i < numFormats; ++i) {
            this.addFormat(formats[i]);
        }
    }

    public boolean containsFormat(int format) {
        return this.formats.containsKey(format);
    }

    public void setFormatParameters(short payloadType, FormatParameterAttribute parameters) {
        RtpMapAttribute format = this.formats.get(payloadType);
        if (format != null) {
            format.setParameters(parameters);
        }
    }

    public ConnectionField getConnection() {
        if (this.connection == null && this.session != null) {
            return this.session.getConnection();
        }
        return this.connection;
    }

    public void setConnection(ConnectionField connection) {
        this.connection = connection;
    }

    public ConnectionModeAttribute getConnectionMode() {
        if (this.connectionMode == null && this.session != null && this.session.getConnectionMode() != null) {
            return this.session.getConnectionMode();
        }
        return this.connectionMode;
    }

    public void setConnectionMode(ConnectionModeAttribute connectionMode) {
        this.connectionMode = connectionMode;
    }

    public RtpMapAttribute[] getFormats() {
        if (this.formats.isEmpty()) {
            return null;
        }
        return this.formats.values().toArray(new RtpMapAttribute[this.formats.size()]);
    }

    public int[] getPayloadTypes() {
        int[] values = new int[this.payloadTypes.size()];
        int index = 0;
        for (Integer value : this.payloadTypes) {
            values[index++] = value;
        }
        return values;
    }

    public RtpMapAttribute getFormat(int payloadType) {
        return this.formats.get(payloadType);
    }

    public RtcpAttribute getRtcp() {
        return this.rtcp;
    }

    public int getRtcpPort() {
        if (this.rtcp != null) {
            return this.rtcp.getPort();
        }
        if (this.rtcpMux != null) {
            return this.port;
        }
        return this.port + 1;
    }

    public void setRtcp(RtcpAttribute rtcp) {
        this.rtcp = rtcp;
    }

    public RtcpMuxAttribute getRtcpMux() {
        return this.rtcpMux;
    }

    public boolean isRtcpMux() {
        return this.rtcpMux != null;
    }

    public void setRtcpMux(RtcpMuxAttribute rtcpMux) {
        this.rtcpMux = rtcpMux;
    }

    public PacketTimeAttribute getPtime() {
        return this.ptime;
    }

    public void setPtime(PacketTimeAttribute ptime) {
        this.ptime = ptime;
    }

    public MaxPacketTimeAttribute getMaxptime() {
        return this.maxptime;
    }

    public void setMaxptime(MaxPacketTimeAttribute maxptime) {
        this.maxptime = maxptime;
    }

    public SsrcAttribute getSsrc() {
        return this.ssrc;
    }

    public void setSsrc(SsrcAttribute ssrc) {
        this.ssrc = ssrc;
    }

    public IceUfragAttribute getIceUfrag() {
        if (this.iceUfrag == null && this.session != null) {
            return this.session.getIceUfrag();
        }
        return this.iceUfrag;
    }

    public void setIceUfrag(IceUfragAttribute iceUfrag) {
        this.iceUfrag = iceUfrag;
    }

    public IcePwdAttribute getIcePwd() {
        if (this.icePwd == null && this.session != null) {
            return this.session.getIcePwd();
        }
        return this.icePwd;
    }

    public void setIcePwd(IcePwdAttribute icePwd) {
        this.icePwd = icePwd;
    }

    public CandidateAttribute[] getCandidates() {
        if (this.candidates == null || this.candidates.isEmpty()) {
            return null;
        }
        return this.candidates.toArray(new CandidateAttribute[this.candidates.size()]);
    }

    public boolean containsCandidates() {
        return this.candidates != null && !this.candidates.isEmpty();
    }

    public void addCandidate(CandidateAttribute candidate) {
        if (this.candidates == null) {
            this.candidates = new ArrayList<CandidateAttribute>(8);
            this.candidates.add(candidate);
        } else if (!this.candidates.contains(candidate)) {
            this.candidates.add(candidate);
        }
    }

    public void removeCandidate(CandidateAttribute candidate) {
        if (this.candidates != null) {
            this.candidates.remove(candidate);
        }
    }

    public void removeAllCandidates() {
        if (this.candidates != null) {
            this.candidates.clear();
        }
    }

    public boolean containsIce() {
        return this.iceUfrag != null || this.icePwd != null || this.containsCandidates();
    }

    public FingerprintAttribute getFingerprint() {
        if (this.fingerprint == null && this.session != null) {
            return this.session.getFingerprint();
        }
        return this.fingerprint;
    }

    public void setFingerprint(FingerprintAttribute fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean containsDtls() {
        return this.fingerprint != null;
    }

    public SetupAttribute getSetup() {
        if (this.setup == null && this.session != null && this.session.getSetup() != null) {
            return this.session.getSetup();
        }
        return this.setup;
    }

    public void setSetup(SetupAttribute setup) {
        this.setup = setup;
    }

    @Override
    public char getFieldType() {
        return 'm';
    }

    public String toString() {
        this.builder.setLength(0);
        this.builder.append(BEGIN).append(this.media).append(" ").append(this.port).append(" ").append(this.protocol);
        for (Integer payloadType : this.payloadTypes) {
            this.builder.append(" ").append(payloadType);
        }
        this.appendField(this.connection);
        this.appendField(this.connectionMode);
        this.appendField(this.rtcp);
        this.appendField(this.rtcpMux);
        this.appendField(this.ptime);
        this.appendField(this.maxptime);
        this.appendField(this.iceUfrag);
        this.appendField(this.icePwd);
        if (this.candidates != null && !this.candidates.isEmpty()) {
            for (CandidateAttribute candidate : this.candidates) {
                this.appendField(candidate);
            }
        }
        if (this.formats != null && !this.formats.isEmpty()) {
            for (RtpMapAttribute format : this.formats.values()) {
                this.appendField(format);
            }
        }
        this.appendField(this.setup);
        this.appendField(this.fingerprint);
        this.appendField(this.ssrc);
        return this.builder.toString();
    }

    private void appendField(SdpField field) {
        if (field != null) {
            this.builder.append(NEWLINE).append(field.toString());
        }
    }

    public static boolean isValidProfile(String profile) {
        return MediaProfile.containsProfile(profile);
    }
}

