/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.fields.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.fields.ConnectionField;

public class ConnectionFieldParser
implements SdpParser<ConnectionField> {
    private static final String REGEX = "^c=\\w+\\s\\w+\\s[0-9\\.]+$";
    private static final Pattern PATTERN = Pattern.compile("^c=\\w+\\s\\w+\\s[0-9\\.]+$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public ConnectionField parse(String sdp) throws SdpException {
        try {
            String[] values = sdp.trim().substring(2).split(" ");
            String networkType = values[0];
            String addressType = values[1];
            String address = values[2];
            return new ConnectionField(networkType, addressType, address);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(ConnectionField field, String sdp) throws SdpException {
        try {
            String[] values = sdp.trim().substring(2).split(" ");
            field.setNetworkType(values[0]);
            field.setAddressType(values[1]);
            field.setAddress(values[2]);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

