/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.rtcp.attributes.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.rtcp.attributes.RtcpAttribute;

public class RtcpAttributeParser
implements SdpParser<RtcpAttribute> {
    private static final String REGEX = "^a=rtcp:\\d+(\\s\\w+\\s\\w+\\s[0-9\\.]+)?$";
    private static final Pattern PATTERN = Pattern.compile("^a=rtcp:\\d+(\\s\\w+\\s\\w+\\s[0-9\\.]+)?$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public RtcpAttribute parse(String sdp) throws SdpException {
        try {
            int separator = sdp.indexOf(":");
            if (separator == -1) {
                throw new IllegalArgumentException("No value found");
            }
            String[] values = sdp.trim().substring(separator + 1).split(" ");
            int port = Integer.parseInt(values[0]);
            if (values.length > 1) {
                String netType = values[1];
                String addressType = values[2];
                String address = values[3];
                return new RtcpAttribute(port, netType, addressType, address);
            }
            return new RtcpAttribute(port);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(RtcpAttribute field, String sdp) throws SdpException {
        try {
            int separator = sdp.indexOf(":");
            if (separator == -1) {
                throw new IllegalArgumentException("No value found");
            }
            String[] values = sdp.trim().substring(separator + 1).split(" ");
            int port = Integer.parseInt(values[0]);
            String netType = null;
            String addressType = null;
            String address = null;
            if (values.length > 1) {
                netType = values[1];
                addressType = values[2];
                address = values[3];
            }
            field.setPort(port);
            field.setNetworkType(netType);
            field.setAddressType(addressType);
            field.setAddress(address);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

