/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.stun.messages.attributes.general;

import java.util.Arrays;
import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.attributes.StunAttribute;

public class ReservationTokenAttribute
extends StunAttribute {
    public static final String NAME = "RESERVATION-TOKEN";
    public static final char DATA_LENGTH = '\b';
    private byte[] reservationToken;

    public ReservationTokenAttribute() {
        super('\"');
    }

    public byte[] getReservationToken() {
        if (this.reservationToken == null) {
            return null;
        }
        byte[] copy = new byte[this.reservationToken.length];
        System.arraycopy(this.reservationToken, 0, copy, 0, this.reservationToken.length);
        return this.reservationToken;
    }

    public void setReservationToken(byte[] reservationToken) {
        if (reservationToken == null) {
            this.reservationToken = null;
        } else {
            this.reservationToken = new byte[reservationToken.length];
            System.arraycopy(reservationToken, 0, this.reservationToken, 0, reservationToken.length);
        }
    }

    @Override
    public char getDataLength() {
        return '\b';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof ReservationTokenAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ReservationTokenAttribute att = (ReservationTokenAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.reservationToken, this.reservationToken);
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[12];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = 0;
        binValue[3] = 8;
        System.arraycopy(this.reservationToken, 0, binValue, 4, 8);
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        if (length != '\b') {
            throw new StunException("Length mismatch.");
        }
        this.reservationToken = new byte[length];
        System.arraycopy(data, offset, this.reservationToken, 0, length);
    }
}

