/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.stun.messages.attributes;

import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.attributes.StunAttribute;
import org.restcomm.media.stun.messages.attributes.address.AlternateServerAttribute;
import org.restcomm.media.stun.messages.attributes.address.ChangedAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.ReflectedFromAttribute;
import org.restcomm.media.stun.messages.attributes.address.ResponseAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.SourceAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.XorMappedAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.XorPeerAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.XorRelayedAddressAttribute;
import org.restcomm.media.stun.messages.attributes.control.ControlledAttribute;
import org.restcomm.media.stun.messages.attributes.control.ControllingAttribute;
import org.restcomm.media.stun.messages.attributes.data.DataAttribute;
import org.restcomm.media.stun.messages.attributes.general.ChangeRequestAttribute;
import org.restcomm.media.stun.messages.attributes.general.ChannelNumberAttribute;
import org.restcomm.media.stun.messages.attributes.general.DontFragmentAttribute;
import org.restcomm.media.stun.messages.attributes.general.ErrorCodeAttribute;
import org.restcomm.media.stun.messages.attributes.general.EvenPortAttribute;
import org.restcomm.media.stun.messages.attributes.general.FingerprintAttribute;
import org.restcomm.media.stun.messages.attributes.general.LifetimeAttribute;
import org.restcomm.media.stun.messages.attributes.general.MappedAddressAttribute;
import org.restcomm.media.stun.messages.attributes.general.MessageIntegrityAttribute;
import org.restcomm.media.stun.messages.attributes.general.NonceAttribute;
import org.restcomm.media.stun.messages.attributes.general.OptionalAttribute;
import org.restcomm.media.stun.messages.attributes.general.PriorityAttribute;
import org.restcomm.media.stun.messages.attributes.general.RealmAttribute;
import org.restcomm.media.stun.messages.attributes.general.RequestedTransportAttribute;
import org.restcomm.media.stun.messages.attributes.general.ReservationTokenAttribute;
import org.restcomm.media.stun.messages.attributes.general.SoftwareAttribute;
import org.restcomm.media.stun.messages.attributes.general.UnknownAttributesAttribute;
import org.restcomm.media.stun.messages.attributes.general.UseCandidateAttribute;
import org.restcomm.media.stun.messages.attributes.general.UsernameAttribute;
import org.restcomm.media.stun.messages.attributes.general.XorOnlyAttribute;

public class StunAttributeDecoder {
    public static StunAttribute decode(byte[] bytes, char offset, char length) throws StunException {
        if (bytes == null || bytes.length < 4) {
            throw new StunException(2, "Could not decode the specified binary array.");
        }
        char attributeType = (char)(bytes[offset] << 8 | bytes[offset + '\u0001']);
        int len1 = bytes[offset + 2] & 0xFF;
        int len2 = bytes[offset + 3] & 0xFF;
        char attributeLength = (char)(len1 << 8 | len2);
        if (attributeLength > bytes.length - offset) {
            throw new StunException(2, "Could not decode the specified binary array.");
        }
        StunAttribute decodedAttribute = null;
        switch (attributeType) {
            case '\u0003': {
                decodedAttribute = new ChangeRequestAttribute();
                break;
            }
            case '\u0005': {
                decodedAttribute = new ChangedAddressAttribute();
                break;
            }
            case '\u0001': {
                decodedAttribute = new MappedAddressAttribute();
                break;
            }
            case '\t': {
                decodedAttribute = new ErrorCodeAttribute();
                break;
            }
            case '\b': {
                decodedAttribute = new MessageIntegrityAttribute();
                break;
            }
            case '\u000b': {
                decodedAttribute = new ReflectedFromAttribute();
                break;
            }
            case '\u0002': {
                decodedAttribute = new ResponseAddressAttribute();
                break;
            }
            case '\u0004': {
                decodedAttribute = new SourceAddressAttribute();
                break;
            }
            case '\n': {
                decodedAttribute = new UnknownAttributesAttribute();
                break;
            }
            case ' ': {
                decodedAttribute = new XorMappedAddressAttribute();
                break;
            }
            case '!': {
                decodedAttribute = new XorOnlyAttribute();
                break;
            }
            case '\u8022': {
                decodedAttribute = new SoftwareAttribute();
                break;
            }
            case '\u0006': {
                decodedAttribute = new UsernameAttribute();
                break;
            }
            case '\u0014': {
                decodedAttribute = new RealmAttribute();
                break;
            }
            case '\u0015': {
                decodedAttribute = new NonceAttribute();
                break;
            }
            case '\u8028': {
                decodedAttribute = new FingerprintAttribute();
                break;
            }
            case '\u8023': {
                decodedAttribute = new AlternateServerAttribute();
                break;
            }
            case '\f': {
                decodedAttribute = new ChannelNumberAttribute();
                break;
            }
            case '\r': {
                decodedAttribute = new LifetimeAttribute();
                break;
            }
            case '\u0012': {
                decodedAttribute = new XorPeerAddressAttribute();
                break;
            }
            case '\u0013': {
                decodedAttribute = new DataAttribute();
                break;
            }
            case '\u0016': {
                decodedAttribute = new XorRelayedAddressAttribute();
                break;
            }
            case '\u0018': {
                decodedAttribute = new EvenPortAttribute();
                break;
            }
            case '\u0019': {
                decodedAttribute = new RequestedTransportAttribute();
                break;
            }
            case '\u001a': {
                decodedAttribute = new DontFragmentAttribute();
                break;
            }
            case '\"': {
                decodedAttribute = new ReservationTokenAttribute();
                break;
            }
            case '$': {
                decodedAttribute = new PriorityAttribute();
                break;
            }
            case '\u802a': {
                decodedAttribute = new ControllingAttribute();
                break;
            }
            case '\u8029': {
                decodedAttribute = new ControlledAttribute();
                break;
            }
            case '%': {
                decodedAttribute = new UseCandidateAttribute();
                break;
            }
            default: {
                decodedAttribute = new OptionalAttribute('\u8000');
            }
        }
        decodedAttribute.setAttributeType(attributeType);
        decodedAttribute.setLocationInMessage(offset);
        decodedAttribute.decodeAttributeBody(bytes, (char)(4 + offset), attributeLength);
        return decodedAttribute;
    }
}

