/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.stun.messages.attributes.general;

import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.attributes.StunAttribute;

public class ChangeRequestAttribute
extends StunAttribute {
    public static final String NAME = "CHANGE-REQUEST";
    public static final char DATA_LENGTH = '\u0004';
    private boolean changeAddress = false;
    private boolean changePort = false;

    public ChangeRequestAttribute() {
        super('\u0003');
    }

    public boolean isAddressChanging() {
        return this.changeAddress;
    }

    public void setAddressChanging(boolean change) {
        this.changeAddress = change;
    }

    public boolean isPortChanging() {
        return this.changePort;
    }

    public void setPortChanging(boolean change) {
        this.changePort = change;
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof ChangeRequestAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ChangeRequestAttribute att = (ChangeRequestAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.isAddressChanging() == this.isAddressChanging() && att.isPortChanging() == this.isPortChanging();
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[]{(byte)(this.getAttributeType() >> 8), (byte)(this.getAttributeType() & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), 0, 0, 0, (byte)((this.isAddressChanging() ? 4 : 0) + (this.isPortChanging() ? 2 : 0))};
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        this.setAddressChanging((attributeValue[offset = (char)(offset + 3)] & 4) > 0);
        this.setPortChanging((attributeValue[offset] & 2) > 0);
    }
}

