/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.stun.messages.attributes.general;

import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.attributes.StunAttribute;

public class RequestedTransportAttribute
extends StunAttribute {
    public static final String NAME = "REQUESTED-TRANSPORT";
    public static final char DATA_LENGTH = '\u0004';
    private static final byte UDP = 17;
    private static final byte TCP = 6;
    private byte requestedTransport = (byte)17;

    public RequestedTransportAttribute() {
        super('\u0019');
    }

    public byte getRequestedTransport() {
        return this.requestedTransport;
    }

    public void setRequestedTransport(byte transport) {
        this.requestedTransport = transport;
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof RequestedTransportAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        RequestedTransportAttribute att = (RequestedTransportAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.requestedTransport == this.requestedTransport;
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[]{(byte)(this.getAttributeType() >> 8), (byte)(this.getAttributeType() & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), this.requestedTransport, 0, 0, 0};
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        if (length != '\u0004') {
            throw new StunException("Invalid Length");
        }
        this.requestedTransport = data[0];
    }
}

