/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.stun.messages.attributes.control;

import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.attributes.StunAttribute;

public abstract class ControlAttribute
extends StunAttribute {
    protected static final String ICE_CONTROLLED_NAME = "ICE_CONTROLLED";
    protected static final String ICE_CONTROLLING_NAME = "ICE_CONTROLLING";
    protected static final char DATA_LENGTH = '\b';
    protected long tieBreaker = -1L;
    protected boolean controlling;

    protected ControlAttribute(boolean isControlling) {
        super(isControlling ? (char)'\u802a' : '\u8029');
        this.controlling = isControlling;
    }

    public long getTieBreaker() {
        return this.tieBreaker;
    }

    public void setTieBreaker(long tieBreaker) {
        this.tieBreaker = tieBreaker;
    }

    public boolean isControlling() {
        return this.controlling;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        char c = offset;
        char c2 = offset = (char)(offset + '\u0001');
        char c3 = offset = (char)(offset + '\u0001');
        char c4 = offset = (char)(offset + '\u0001');
        char c5 = offset = (char)(offset + '\u0001');
        char c6 = offset = (char)(offset + '\u0001');
        char c7 = offset = (char)(offset + '\u0001');
        char c8 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        this.tieBreaker = ((long)data[c] & 0xFFL) << 56 | ((long)data[c2] & 0xFFL) << 48 | ((long)data[c3] & 0xFFL) << 40 | ((long)data[c4] & 0xFFL) << 32 | ((long)data[c5] & 0xFFL) << 24 | ((long)data[c6] & 0xFFL) << 16 | ((long)data[c7] & 0xFFL) << 8 | (long)data[c8] & 0xFFL;
    }

    @Override
    public char getDataLength() {
        return '\b';
    }

    @Override
    public String getName() {
        if (this.controlling) {
            return ICE_CONTROLLING_NAME;
        }
        return ICE_CONTROLLED_NAME;
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        binValue[4] = (byte)((this.tieBreaker & 0xFF00000000000000L) >> 56);
        binValue[5] = (byte)((this.tieBreaker & 0xFF000000000000L) >> 48);
        binValue[6] = (byte)((this.tieBreaker & 0xFF0000000000L) >> 40);
        binValue[7] = (byte)((this.tieBreaker & 0xFF00000000L) >> 32);
        binValue[8] = (byte)((this.tieBreaker & 0xFF000000L) >> 24);
        binValue[9] = (byte)((this.tieBreaker & 0xFF0000L) >> 16);
        binValue[10] = (byte)((this.tieBreaker & 0xFF00L) >> 8);
        binValue[11] = (byte)(this.tieBreaker & 0xFFL);
        return binValue;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof ControlAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ControlAttribute iceControlAtt = (ControlAttribute)other;
        return iceControlAtt.getAttributeType() == this.getAttributeType() && iceControlAtt.controlling == this.controlling && iceControlAtt.getDataLength() == '\b' && iceControlAtt.getTieBreaker() == this.tieBreaker;
    }
}

