/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.stun.messages.attributes;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import org.restcomm.media.network.deprecated.TransportAddress;
import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.attributes.address.ChangedAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.DestinationAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.ReflectedFromAttribute;
import org.restcomm.media.stun.messages.attributes.address.ResponseAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.SourceAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.XorMappedAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.XorPeerAddressAttribute;
import org.restcomm.media.stun.messages.attributes.address.XorRelayedAddressAttribute;
import org.restcomm.media.stun.messages.attributes.control.ControlledAttribute;
import org.restcomm.media.stun.messages.attributes.control.ControllingAttribute;
import org.restcomm.media.stun.messages.attributes.data.DataAttribute;
import org.restcomm.media.stun.messages.attributes.general.ChangeRequestAttribute;
import org.restcomm.media.stun.messages.attributes.general.ChannelNumberAttribute;
import org.restcomm.media.stun.messages.attributes.general.ErrorCodeAttribute;
import org.restcomm.media.stun.messages.attributes.general.EvenPortAttribute;
import org.restcomm.media.stun.messages.attributes.general.FingerprintAttribute;
import org.restcomm.media.stun.messages.attributes.general.LifetimeAttribute;
import org.restcomm.media.stun.messages.attributes.general.MagicCookieAttribute;
import org.restcomm.media.stun.messages.attributes.general.MappedAddressAttribute;
import org.restcomm.media.stun.messages.attributes.general.MessageIntegrityAttribute;
import org.restcomm.media.stun.messages.attributes.general.NonceAttribute;
import org.restcomm.media.stun.messages.attributes.general.PriorityAttribute;
import org.restcomm.media.stun.messages.attributes.general.RealmAttribute;
import org.restcomm.media.stun.messages.attributes.general.RequestedTransportAttribute;
import org.restcomm.media.stun.messages.attributes.general.ReservationTokenAttribute;
import org.restcomm.media.stun.messages.attributes.general.SoftwareAttribute;
import org.restcomm.media.stun.messages.attributes.general.UnknownAttributesAttribute;
import org.restcomm.media.stun.messages.attributes.general.UseCandidateAttribute;
import org.restcomm.media.stun.messages.attributes.general.UsernameAttribute;

public class StunAttributeFactory {
    public static ChangeRequestAttribute createChangeRequestAttribute() {
        return StunAttributeFactory.createChangeRequestAttribute(false, false);
    }

    public static ChangeRequestAttribute createChangeRequestAttribute(boolean changeIP, boolean changePort) {
        ChangeRequestAttribute attribute = new ChangeRequestAttribute();
        attribute.setAddressChanging(changeIP);
        attribute.setPortChanging(changePort);
        return attribute;
    }

    public static ChangedAddressAttribute createChangedAddressAttribute(TransportAddress address) {
        ChangedAddressAttribute attribute = new ChangedAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(byte errorClass, byte errorNumber) throws StunException {
        return StunAttributeFactory.createErrorCodeAttribute(errorClass, errorNumber, null);
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(byte errorClass, byte errorNumber, String reasonPhrase) throws StunException {
        ErrorCodeAttribute attribute = new ErrorCodeAttribute();
        attribute.setErrorClass(errorClass);
        attribute.setErrorNumber(errorNumber);
        attribute.setReasonPhrase(reasonPhrase == null ? ErrorCodeAttribute.getDefaultReasonPhrase(attribute.getErrorCode()) : reasonPhrase);
        return attribute;
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(char errorCode) throws StunException {
        return StunAttributeFactory.createErrorCodeAttribute(errorCode, null);
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(char errorCode, String reasonPhrase) throws IllegalArgumentException {
        ErrorCodeAttribute attribute = new ErrorCodeAttribute();
        attribute.setErrorCode(errorCode);
        attribute.setReasonPhrase(reasonPhrase == null ? ErrorCodeAttribute.getDefaultReasonPhrase(attribute.getErrorCode()) : reasonPhrase);
        return attribute;
    }

    public static MappedAddressAttribute createMappedAddressAttribute(TransportAddress address) {
        MappedAddressAttribute attribute = new MappedAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static ReflectedFromAttribute createReflectedFromAttribute(TransportAddress address) {
        ReflectedFromAttribute attribute = new ReflectedFromAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static ResponseAddressAttribute createResponseAddressAttribute(TransportAddress address) {
        ResponseAddressAttribute attribute = new ResponseAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static SourceAddressAttribute createSourceAddressAttribute(TransportAddress address) {
        SourceAddressAttribute attribute = new SourceAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static UnknownAttributesAttribute createUnknownAttributesAttribute() {
        UnknownAttributesAttribute attribute = new UnknownAttributesAttribute();
        return attribute;
    }

    public static XorRelayedAddressAttribute createXorRelayedAddressAttribute(TransportAddress address, byte[] tranID) {
        XorRelayedAddressAttribute attribute = new XorRelayedAddressAttribute();
        attribute.setAddress(address, tranID);
        return attribute;
    }

    public static XorPeerAddressAttribute createXorPeerAddressAttribute(TransportAddress address, byte[] tranID) {
        XorPeerAddressAttribute attribute = new XorPeerAddressAttribute();
        attribute.setAddress(address, tranID);
        return attribute;
    }

    public static XorMappedAddressAttribute createXorMappedAddressAttribute(TransportAddress address, byte[] tranID) {
        XorMappedAddressAttribute attribute = new XorMappedAddressAttribute();
        attribute.setAddress(address, tranID);
        return attribute;
    }

    public static UsernameAttribute createUsernameAttribute(byte[] username) {
        UsernameAttribute attribute = new UsernameAttribute();
        attribute.setUsername(username);
        return attribute;
    }

    public static UsernameAttribute createUsernameAttribute(String username) {
        UsernameAttribute attribute = new UsernameAttribute();
        try {
            attribute.setUsername(username.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ueex) {
            throw new UndeclaredThrowableException(ueex);
        }
        return attribute;
    }

    public static MessageIntegrityAttribute createMessageIntegrityAttribute(String username, byte[] key) {
        MessageIntegrityAttribute attribute = new MessageIntegrityAttribute();
        attribute.setKey(key);
        attribute.setUsername(username);
        return attribute;
    }

    public static FingerprintAttribute createFingerprintAttribute() {
        FingerprintAttribute attribute = new FingerprintAttribute();
        return attribute;
    }

    public static ChannelNumberAttribute createChannelNumberAttribute(char channelNumber) {
        ChannelNumberAttribute attribute = new ChannelNumberAttribute();
        attribute.setChannelNumber(channelNumber);
        return attribute;
    }

    public static RealmAttribute createRealmAttribute(byte[] realm) {
        RealmAttribute attribute = new RealmAttribute();
        attribute.setRealm(realm);
        return attribute;
    }

    public static NonceAttribute createNonceAttribute(byte[] nonce) {
        NonceAttribute attribute = new NonceAttribute();
        attribute.setNonce(nonce);
        return attribute;
    }

    public static SoftwareAttribute createSoftwareAttribute(byte[] software) {
        SoftwareAttribute attribute = new SoftwareAttribute();
        attribute.setSoftware(software);
        return attribute;
    }

    public static EvenPortAttribute createEvenPortAttribute(boolean rFlag) {
        EvenPortAttribute attribute = new EvenPortAttribute();
        attribute.setRFlag(rFlag);
        return attribute;
    }

    public static LifetimeAttribute createLifetimeAttribute(int lifetime) {
        LifetimeAttribute attribute = new LifetimeAttribute();
        attribute.setLifetime(lifetime);
        return attribute;
    }

    public static RequestedTransportAttribute createRequestedTransportAttribute(byte protocol) {
        RequestedTransportAttribute attribute = new RequestedTransportAttribute();
        attribute.setRequestedTransport(protocol);
        return attribute;
    }

    public static ReservationTokenAttribute createReservationTokenAttribute(byte[] token) {
        ReservationTokenAttribute attribute = new ReservationTokenAttribute();
        attribute.setReservationToken(token);
        return attribute;
    }

    public static DataAttribute createDataAttribute(byte[] data) {
        DataAttribute attribute = new DataAttribute();
        attribute.setData(data);
        return attribute;
    }

    public static DataAttribute createDataAttributeWithoutPadding(byte[] data) {
        DataAttribute attribute = new DataAttribute(false);
        attribute.setData(data);
        return attribute;
    }

    public static ControlledAttribute createIceControlledAttribute(long tieBreaker) {
        ControlledAttribute attribute = new ControlledAttribute();
        attribute.setTieBreaker(tieBreaker);
        return attribute;
    }

    public static PriorityAttribute createPriorityAttribute(long priority) throws IllegalArgumentException {
        PriorityAttribute attribute = new PriorityAttribute();
        attribute.setPriority(priority);
        return attribute;
    }

    public static UseCandidateAttribute createUseCandidateAttribute() {
        UseCandidateAttribute attribute = new UseCandidateAttribute();
        return attribute;
    }

    public static ControllingAttribute createIceControllingAttribute(long tieBreaker) {
        ControllingAttribute attribute = new ControllingAttribute();
        attribute.setTieBreaker(tieBreaker);
        return attribute;
    }

    public static MagicCookieAttribute createMagicCookieAttribute() {
        MagicCookieAttribute attribute = new MagicCookieAttribute();
        return attribute;
    }

    public static DestinationAddressAttribute createDestinationAddressAttribute(TransportAddress address) {
        DestinationAddressAttribute attribute = new DestinationAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }
}

