/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.stun.messages.attributes.general;

import java.util.Arrays;
import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.attributes.StunAttribute;

public class OptionalAttribute
extends StunAttribute {
    private static final String NAME = "OPTIONAL";
    byte[] body = null;

    public OptionalAttribute(char attributeType) {
        super(attributeType);
    }

    public byte[] getBody() {
        if (this.body == null) {
            return null;
        }
        return (byte[])this.body.clone();
    }

    public void setBody(byte[] body, int offset, int length) {
        this.body = new byte[length];
        System.arraycopy(body, offset, this.body, 0, length);
    }

    @Override
    public char getDataLength() {
        return (char)this.body.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof OptionalAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        OptionalAttribute att = (OptionalAttribute)other;
        return Arrays.equals(this.body, att.body);
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.body.length];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.body, 0, binValue, 4, this.body.length);
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        this.body = new byte[length];
        System.arraycopy(data, offset, this.body, 0, length);
    }
}

