/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.stun.messages.attributes.general;

import java.util.ArrayList;
import java.util.Iterator;
import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.attributes.StunAttribute;

public class UnknownAttributesAttribute
extends StunAttribute {
    public static String NAME = "UNKNOWN-ATTRIBUTES";
    private ArrayList<Character> unknownAttributes = new ArrayList();

    public UnknownAttributesAttribute() {
        super('\n');
    }

    @Override
    public char getDataLength() {
        if (this.unknownAttributes == null) {
            return '\u0000';
        }
        char length = (char)this.unknownAttributes.size();
        if (length % 2 != 0) {
            length = (char)(length + '\u0001');
        }
        return (char)(length * 2);
    }

    public boolean contains(char attributeID) {
        return this.unknownAttributes.contains(new Character(attributeID));
    }

    public void addAttributeId(char attributeId) {
        if (!this.contains(attributeId)) {
            this.unknownAttributes.add(new Character(attributeId));
        }
    }

    public Iterator<Character> getAttributes() {
        return this.unknownAttributes.iterator();
    }

    public int getAttributeCount() {
        return this.unknownAttributes.size();
    }

    public char getAttribute(int index) {
        return this.unknownAttributes.get(index).charValue();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof UnknownAttributesAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        UnknownAttributesAttribute att = (UnknownAttributesAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && this.unknownAttributes.equals(att.unknownAttributes);
    }

    @Override
    public byte[] encode() {
        char att;
        byte[] binValue = new byte[this.getDataLength() + 4];
        int offset = 0;
        binValue[offset++] = (byte)(this.getAttributeType() >> 8);
        binValue[offset++] = (byte)(this.getAttributeType() & 0xFF);
        binValue[offset++] = (byte)(this.getDataLength() >> 8);
        binValue[offset++] = (byte)(this.getDataLength() & 0xFF);
        Iterator<Character> attributes = this.getAttributes();
        while (attributes.hasNext()) {
            att = attributes.next().charValue();
            binValue[offset++] = (byte)(att >> 8);
            binValue[offset++] = (byte)(att & 0xFF);
        }
        if (offset < binValue.length) {
            att = this.getAttribute(0);
            binValue[offset++] = (byte)(att >> 8);
            binValue[offset++] = (byte)(att & 0xFF);
        }
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        if (length % 2 != 0) {
            throw new StunException("Attribute IDs are 2 bytes long and the passed binary array has an odd length value.");
        }
        int originalOffset = offset;
        for (int i = offset; i < originalOffset + length; i += 2) {
            int n = offset;
            int n2 = offset = (char)(offset + '\u0001');
            offset = (char)(offset + '\u0001');
            char attributeID = (char)(data[n] << 8 | data[n2]);
            this.addAttributeId(attributeID);
        }
    }
}

