/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.restcomm.connect.rvd.ProjectLogger;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.RvdContext;
import org.restcomm.connect.rvd.model.ProjectSettings;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageEntityNotFound;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;

public class ProjectAwareRvdContext
extends RvdContext {
    private String projectName;
    private ProjectLogger projectLogger;
    private ProjectSettings projectSettings;

    public ProjectAwareRvdContext(String projectName, HttpServletRequest request, ServletContext servletContext, RvdConfiguration configuration) throws StorageException {
        super(request, servletContext, configuration);
        if (projectName == null) {
            throw new IllegalArgumentException();
        }
        this.setProjectName(projectName);
    }

    public ProjectAwareRvdContext(HttpServletRequest request, ServletContext servletContext, RvdConfiguration configuration) {
        super(request, servletContext, configuration);
    }

    public ProjectLogger getProjectLogger() {
        return this.projectLogger;
    }

    public ProjectSettings getProjectSettings() {
        return this.projectSettings;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        if (projectName != null) {
            this.projectLogger = new ProjectLogger(projectName, this.getSettings(), this.getMarshaler());
            try {
                this.projectSettings = FsProjectStorage.loadProjectSettings((String)projectName, (WorkspaceStorage)this.workspaceStorage);
            }
            catch (StorageEntityNotFound e) {
                this.projectSettings = ProjectSettings.createDefault();
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.projectLogger = null;
            this.projectSettings = null;
        }
    }

    public String getProjectName() {
        return this.projectName;
    }
}

