/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.model.ModelMarshaler;

public class ProjectLogger {
    static final Logger logger = Logger.getLogger((String)ProjectLogger.class.getName());
    private static final int MAX_TAGS = 5;
    private String projectName;
    private String logFilePath;
    private ModelMarshaler marshaler;
    private boolean useMarshaler;
    private Object payload;
    private String[] tags;
    private int tagCount = 0;

    public ProjectLogger(String projectName, RvdConfiguration settings, ModelMarshaler marshaler) {
        this.projectName = projectName;
        this.logFilePath = settings.getProjectBasePath(projectName) + File.separator + "projectLog";
        this.marshaler = marshaler;
        this.useMarshaler = true;
    }

    public ProjectLogger log(Object payload) {
        this.tags = new String[5];
        this.tagCount = 0;
        this.payload = payload;
        return this;
    }

    public ProjectLogger log(Object payload, boolean useMarshaler) {
        this.useMarshaler = useMarshaler;
        return this.log(payload);
    }

    public ProjectLogger tag(String name, String value) {
        if (this.tagCount < 5) {
            this.tags[this.tagCount] = value == null ? "[" + name + "]" : "[" + name + " " + value + "]";
            ++this.tagCount;
        } else {
            logger.warn((Object)"ProjectLogger: Cannot add any more tags to the log entry");
        }
        return this;
    }

    public ProjectLogger tag(String name) {
        return this.tag(name, null);
    }

    public void done() {
        Date date = new Date();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + date.toString() + "]");
        for (String tag : this.tags) {
            if (tag == null) break;
            buffer.append(tag);
        }
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        if (this.useMarshaler) {
            buffer.append(this.marshaler.toData(this.payload));
        } else {
            buffer.append(String.valueOf(this.payload));
        }
        buffer.append(System.getProperty("line.separator"));
        try {
            FileUtils.writeStringToFile((File)new File(this.logFilePath), (String)buffer.toString(), (Charset)Charset.forName("UTF-8"), (boolean)true);
        }
        catch (IOException e) {
            logger.warn((Object)("Error writing to application log for " + this.projectName), (Throwable)e);
        }
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void reset() {
        try {
            FileUtils.writeStringToFile((File)new File(this.logFilePath), (String)"");
        }
        catch (IOException e) {
            logger.warn((Object)("Error clearing application log for " + this.projectName), (Throwable)e);
        }
    }
}

