/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.commons.http;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.commons.http.SslMode;

public class CustomHttpClientBuilder {
    private SslMode sslMode;

    public CustomHttpClientBuilder(RvdConfiguration configuration) {
        this.sslMode = configuration.getSslMode();
    }

    public CloseableHttpClient buildHttpClient() {
        if (this.sslMode == SslMode.strict) {
            return this.buildStrictClient();
        }
        return this.buildAllowallClient();
    }

    private CloseableHttpClient buildStrictClient() {
        String[] protocols = this.getSSLPrototocolsFromSystemProperties();
        if (protocols == null) {
            return HttpClients.createDefault();
        }
        SSLContext sslcontext = SSLContexts.createDefault();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, protocols, null, (HostnameVerifier)new DefaultHostnameVerifier());
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        return httpclient;
    }

    private CloseableHttpClient buildAllowallClient() {
        SSLContext sslcontext;
        String[] protocols = this.getSSLPrototocolsFromSystemProperties();
        try {
            sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, protocols, null, (HostnameVerifier)new NoopHostnameVerifier());
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        return httpclient;
    }

    private String[] getSSLPrototocolsFromSystemProperties() {
        String protocols = System.getProperty("jdk.tls.client.protocols");
        if (protocols == null) {
            protocols = System.getProperty("https.protocols");
        }
        if (protocols != null) {
            String[] protocolsArray = protocols.split(",");
            return protocolsArray;
        }
        return null;
    }
}

