/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.configuration;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.restcomm.connect.rvd.commons.http.SslMode;
import org.restcomm.connect.rvd.exceptions.RestcommConfigNotFound;
import org.restcomm.connect.rvd.exceptions.RestcommConfigProcessError;
import org.restcomm.connect.rvd.exceptions.RestcommConfigurationException;
import org.restcomm.connect.rvd.utils.RvdUtils;
import org.w3c.dom.Document;

public class RestcommConfig {
    SslMode sslMode;
    String hostname;
    boolean useHostnameToResolveRelativeUrl;
    String authServerUrl;
    String realmPublicKey;
    String realm;

    public RestcommConfig(String restcommXmlPath) throws RestcommConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        File file = new File(restcommXmlPath);
        if (!file.exists() || !file.canRead()) {
            throw new RestcommConfigNotFound("Cannot find or read restcomm configuration file: " + restcommXmlPath);
        }
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("/restcomm/http-client/ssl-mode/text()");
            String sslMode = (String)expr.evaluate(doc, XPathConstants.STRING);
            expr = xpath.compile("/restcomm/http-client/use-hostname-to-resolve-relative-url/text()");
            String useHostname = (String)expr.evaluate(doc, XPathConstants.STRING);
            expr = xpath.compile("/restcomm/http-client/hostname/text()");
            String hostname = (String)expr.evaluate(doc, XPathConstants.STRING);
            expr = xpath.compile("/restcomm/identity/auth-server-url/text()");
            this.authServerUrl = (String)expr.evaluate(doc, XPathConstants.STRING);
            expr = xpath.compile("/restcomm/identity/realm-public-key/text()");
            this.realmPublicKey = (String)expr.evaluate(doc, XPathConstants.STRING);
            expr = xpath.compile("/restcomm/identity/realm/text()");
            this.realm = (String)expr.evaluate(doc, XPathConstants.STRING);
            this.sslMode = SslMode.strict;
            if (!RvdUtils.isEmpty((String)sslMode)) {
                this.sslMode = SslMode.valueOf((String)sslMode);
            }
            this.hostname = hostname;
            try {
                this.useHostnameToResolveRelativeUrl = Boolean.parseBoolean(useHostname);
            }
            catch (Exception e) {
                this.useHostnameToResolveRelativeUrl = true;
            }
        }
        catch (Exception e) {
            throw new RestcommConfigProcessError("Error processing restcomm configuration file '" + restcommXmlPath + "'", (Throwable)e);
        }
    }

    public RestcommConfig(SslMode sslMode, String hostname, boolean useHostnameToResolveRelativeUrl, String authServerUrl, String realmPublicKey, String realm) {
        this.sslMode = sslMode;
        this.hostname = hostname;
        this.useHostnameToResolveRelativeUrl = useHostnameToResolveRelativeUrl;
        this.authServerUrl = authServerUrl;
        this.realmPublicKey = realmPublicKey;
        this.realm = realm;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isUseHostnameToResolveRelativeUrl() {
        return this.useHostnameToResolveRelativeUrl;
    }

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public String getRealmPublicKey() {
        return this.realmPublicKey;
    }

    public String getRealm() {
        return this.realm;
    }
}

