/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.configuration;

import org.restcomm.connect.rvd.commons.http.SslMode;
import org.restcomm.connect.rvd.configuration.RestcommConfig;

public class RestcommConfigBuilder {
    private SslMode sslMode = SslMode.strict;
    private String hostname = null;
    private boolean useHostnameToResolveRelativeUrl = true;
    private String authServerUrl = null;
    private String realmPublicKey = null;
    private String realm = null;

    public RestcommConfigBuilder setSslMode(SslMode sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public RestcommConfigBuilder setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public RestcommConfigBuilder setUseHostnameToResolveRelativeUrl(boolean useHostnameToResolveRelativeUrl) {
        this.useHostnameToResolveRelativeUrl = useHostnameToResolveRelativeUrl;
        return this;
    }

    public RestcommConfigBuilder setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
        return this;
    }

    public RestcommConfigBuilder setRealmPublicKey(String realmPublicKey) {
        this.realmPublicKey = realmPublicKey;
        return this;
    }

    public RestcommConfigBuilder setRealm(String realm) {
        this.realm = realm;
        return this;
    }

    public RestcommConfig build() {
        return new RestcommConfig(this.sslMode, this.hostname, this.useHostnameToResolveRelativeUrl, this.authServerUrl, this.realmPublicKey, this.realm);
    }
}

