/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.BuildService;
import org.restcomm.connect.rvd.ProjectApplicationsApi;
import org.restcomm.connect.rvd.ProjectService;
import org.restcomm.connect.rvd.RasService;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.RvdContext;
import org.restcomm.connect.rvd.exceptions.ProjectDoesNotExist;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.exceptions.packaging.PackagingDoesNotExist;
import org.restcomm.connect.rvd.exceptions.project.ProjectException;
import org.restcomm.connect.rvd.exceptions.project.UnsupportedProjectVersion;
import org.restcomm.connect.rvd.exceptions.ras.InvalidRestcommAppPackage;
import org.restcomm.connect.rvd.exceptions.ras.RestcommAppAlreadyExists;
import org.restcomm.connect.rvd.exceptions.ras.UnsupportedRasApplicationVersion;
import org.restcomm.connect.rvd.http.RvdResponse;
import org.restcomm.connect.rvd.http.resources.SecuredRestService;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.model.ModelMarshaler;
import org.restcomm.connect.rvd.model.client.ProjectItem;
import org.restcomm.connect.rvd.model.client.ProjectState;
import org.restcomm.connect.rvd.model.packaging.Rapp;
import org.restcomm.connect.rvd.model.packaging.RappBinaryInfo;
import org.restcomm.connect.rvd.model.packaging.RappConfig;
import org.restcomm.connect.rvd.model.project.RvdProject;
import org.restcomm.connect.rvd.storage.FsPackagingStorage;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageEntityNotFound;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.utils.RvdUtils;
import org.restcomm.connect.rvd.validation.exceptions.RvdValidationException;

@Path(value="ras")
public class RasRestService
extends SecuredRestService {
    static final Logger logger = Logger.getLogger((String)RasRestService.class.getName());
    private RvdConfiguration settings;
    private RasService rasService;
    private ProjectService projectService;
    private RvdContext rvdContext;
    private WorkspaceStorage workspaceStorage;
    private ModelMarshaler marshaler;

    @PostConstruct
    public void init() {
        super.init();
        this.rvdContext = new RvdContext(this.request, this.servletContext, this.applicationContext.getConfiguration());
        this.settings = this.rvdContext.getSettings();
        this.marshaler = this.rvdContext.getMarshaler();
        this.workspaceStorage = new WorkspaceStorage(this.settings.getWorkspaceBasePath(), this.marshaler);
        this.rasService = new RasService(this.rvdContext, this.workspaceStorage);
        this.projectService = new ProjectService(this.rvdContext, this.workspaceStorage);
    }

    public RasRestService() {
    }

    RasRestService(UserIdentityContext context) {
        super(context);
    }

    @GET
    @Path(value="/packaging/app")
    @Produces(value={"application/json"})
    public Response getAppConfig(@QueryParam(value="applicationSid") String applicationSid) throws StorageException, ProjectDoesNotExist {
        this.secure();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("retrieving app package for project " + applicationSid));
        }
        if (!FsPackagingStorage.hasPackaging((String)applicationSid, (WorkspaceStorage)this.workspaceStorage)) {
            return this.buildErrorResponse(Response.Status.NOT_FOUND, RvdResponse.Status.OK, null);
        }
        Rapp rapp = this.rasService.getApp(applicationSid);
        Gson gson = new Gson();
        return Response.ok().entity((Object)gson.toJson((Object)rapp)).build();
    }

    @POST
    @Path(value="/packaging/app/save")
    public Response saveApp(@Context HttpServletRequest request, @QueryParam(value="applicationSid") String applicationSid) {
        this.secure();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("saving restcomm app '" + applicationSid + "'"));
        }
        try {
            String rappData = IOUtils.toString((InputStream)request.getInputStream(), (Charset)Charset.forName("UTF-8"));
            Gson gson = new Gson();
            Rapp rapp = (Rapp)gson.fromJson(rappData, Rapp.class);
            if (!FsPackagingStorage.hasPackaging((String)applicationSid, (WorkspaceStorage)this.workspaceStorage)) {
                this.rasService.createApp(rapp, applicationSid);
            } else {
                this.rasService.saveApp(rapp, applicationSid);
            }
            return this.buildOkResponse();
        }
        catch (IOException e) {
            RvdException returnedError = new RvdException("Error saving rapp", (Throwable)e);
            logger.error((Object)returnedError, (Throwable)returnedError);
            return this.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, RvdResponse.Status.ERROR, returnedError);
        }
        catch (RvdValidationException e) {
            return this.buildInvalidResponse(Response.Status.OK, RvdResponse.Status.INVALID, e.getReport());
        }
        catch (StorageException e) {
            logger.error((Object)e, (Throwable)e);
            return this.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
        catch (ProjectDoesNotExist e) {
            logger.warn((Object)e, (Throwable)e);
            return this.buildErrorResponse(Response.Status.NOT_FOUND, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
    }

    @GET
    @Path(value="/packaging/app/prepare")
    @Produces(value={"application/json"})
    public Response preparePackage(@QueryParam(value="applicationSid") String applicationSid) {
        this.secure();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("preparig app zip for project " + applicationSid));
        }
        try {
            if (FsPackagingStorage.hasPackaging((String)applicationSid, (WorkspaceStorage)this.workspaceStorage)) {
                RvdProject project = this.projectService.load(applicationSid);
                project.getState().getHeader().setOwner(null);
                this.rasService.createZipPackage(project);
                return this.buildErrorResponse(Response.Status.OK, RvdResponse.Status.OK, null);
            }
            return this.buildErrorResponse(Response.Status.OK, RvdResponse.Status.ERROR, (RvdException)new PackagingDoesNotExist());
        }
        catch (RvdException e) {
            logger.error((Object)e, (Throwable)e);
            return this.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, RvdResponse.Status.ERROR, e);
        }
    }

    @GET
    @Path(value="/packaging/binary/info")
    @Produces(value={"application/json"})
    public Response getBinaryStatus(@QueryParam(value="applicationSid") String applicationSid) {
        this.secure();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getting binary info for project " + applicationSid));
        }
        RappBinaryInfo binaryInfo = this.rasService.getBinaryInfo(applicationSid);
        return this.buildOkResponse((Object)binaryInfo);
    }

    @GET
    @Path(value="/packaging/download")
    public Response downloadPackage(@QueryParam(value="projectName") String projectName, @QueryParam(value="applicationSid") String applicationSid) {
        this.secure();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("downloading app zip for project " + applicationSid));
        }
        try {
            if (FsPackagingStorage.hasPackaging((String)applicationSid, (WorkspaceStorage)this.workspaceStorage)) {
                InputStream zipStream = FsPackagingStorage.getRappBinary((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
                return Response.ok((Object)zipStream, (String)"application/zip").header("Content-Disposition", (Object)("attachment; filename*=UTF-8''" + RvdUtils.myUrlEncode((String)(projectName + ".ras.zip")))).build();
            }
            return null;
        }
        catch (RvdException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    @POST
    @Path(value="apps/metadata")
    public Response listRappsByProjectSid(@Context HttpServletRequest request) throws RvdException {
        this.secure();
        List appSids = null;
        try {
            Gson gson = new Gson();
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            appSids = (List)gson.fromJson((Reader)new InputStreamReader((InputStream)request.getInputStream()), type);
        }
        catch (IOException e) {
            throw new RvdException("Internal error while retrieving project Sids", (Throwable)e);
        }
        try {
            List items = this.projectService.getProjectSummaries(appSids, this.getLoggedUsername());
            appSids.clear();
            for (ProjectItem project : items) {
                appSids.add(project.getName());
            }
            List rapps = FsProjectStorage.listRapps((List)appSids, (WorkspaceStorage)this.workspaceStorage, (ProjectService)this.projectService);
            return this.buildOkResponse((Object)rapps);
        }
        catch (StorageException e) {
            return this.buildErrorResponse(Response.Status.OK, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
        catch (ProjectException e) {
            return this.buildErrorResponse(Response.Status.OK, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
    }

    @POST
    @Path(value="apps")
    public Response newRasApp(@Context HttpServletRequest request) {
        this.secure();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"uploading new ras app");
        }
        BuildService buildService = new BuildService(this.workspaceStorage);
        ProjectApplicationsApi applicationsApi = null;
        String applicationSid = null;
        try {
            if (request.getHeader("Content-Type") != null && request.getHeader("Content-Type").startsWith("multipart/form-data")) {
                Gson gson = new Gson();
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iterator = upload.getItemIterator(request);
                JsonArray fileinfos = new JsonArray();
                while (iterator.hasNext()) {
                    FileItemStream item = iterator.next();
                    JsonObject fileinfo = new JsonObject();
                    fileinfo.addProperty("fieldName", item.getFieldName());
                    if (item.getName() != null) {
                        String tempName = "RasImport-" + UUID.randomUUID().toString().replace("-", "");
                        applicationsApi = new ProjectApplicationsApi(this.getUserIdentityContext(), this.applicationContext);
                        applicationSid = applicationsApi.createApplication(tempName, "");
                        String effectiveProjectName = null;
                        try {
                            effectiveProjectName = this.rasService.importAppToWorkspace(applicationSid, item.openStream(), this.getLoggedUsername(), this.projectService);
                            ProjectState projectState = FsProjectStorage.loadProject((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
                            applicationsApi.updateApplication(applicationSid, effectiveProjectName, null, projectState.getHeader().getProjectKind());
                            buildService.buildProject(applicationSid, projectState);
                        }
                        catch (Exception e) {
                            applicationsApi.rollbackCreateApplication(applicationSid);
                            throw e;
                        }
                        fileinfo.addProperty("name", item.getName());
                        fileinfo.addProperty("projectName", effectiveProjectName);
                        fileinfo.addProperty("applicationSid", applicationSid);
                    }
                    if (item.getName() == null) {
                        logger.warn((Object)"non-file part found in upload");
                        fileinfo.addProperty("value", this.read(item.openStream()));
                    }
                    fileinfos.add((JsonElement)fileinfo);
                }
                return Response.ok((Object)gson.toJson((JsonElement)fileinfos), (String)"application/json").build();
            }
            String json_response = "{\"result\":[{\"size\":" + this.size((InputStream)request.getInputStream()) + "}]}";
            return Response.ok((Object)json_response, (String)"application/json").build();
        }
        catch (RestcommAppAlreadyExists e) {
            logger.warn((Object)e);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e, (Throwable)e);
            }
            return this.buildErrorResponse(Response.Status.CONFLICT, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
        catch (UnsupportedProjectVersion | UnsupportedRasApplicationVersion e) {
            logger.error((Object)e.getMessage(), e);
            return this.buildErrorResponse(Response.Status.BAD_REQUEST, RvdResponse.Status.ERROR, (RvdException)e);
        }
        catch (InvalidRestcommAppPackage e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return this.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="apps/{applicationSid}/config")
    public Response getConfig(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        if (FsProjectStorage.hasPackagingInfo((String)applicationSid, (WorkspaceStorage)this.workspaceStorage)) {
            return this.getConfigFromPackaging(applicationSid);
        }
        try {
            RappConfig rappConfig = this.rasService.getRappConfig(applicationSid);
            return this.buildOkResponse((Object)rappConfig);
        }
        catch (StorageEntityNotFound e) {
            return this.buildErrorResponse(Response.Status.OK, RvdResponse.Status.NOT_FOUND, (RvdException)((Object)e));
        }
        catch (StorageException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return this.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
    }

    @GET
    @Path(value="apps/{applicationSid}")
    public Response getRapp(@PathParam(value="applicationSid") String applicationSid) throws StorageException {
        this.secure();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("getting info for " + applicationSid));
        }
        try {
            Rapp rapp = FsProjectStorage.hasPackagingInfo((String)applicationSid, (WorkspaceStorage)this.workspaceStorage) ? FsProjectStorage.loadRappFromPackaging((String)applicationSid, (WorkspaceStorage)this.workspaceStorage) : FsProjectStorage.loadRapp((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
            return this.buildOkResponse((Object)rapp);
        }
        catch (StorageEntityNotFound e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="apps/{applicationSid}/config/dev")
    public Response getConfigFromPackaging(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        try {
            Rapp rapp = FsProjectStorage.loadRappFromPackaging((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
            return this.buildOkResponse((Object)rapp.getConfig());
        }
        catch (StorageException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return this.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
    }

    @POST
    @Path(value="apps/{applicationSid}/bootstrap")
    public Response setBootstrap(@Context HttpServletRequest request, @PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        try {
            String bootstrapInfo = IOUtils.toString((InputStream)request.getInputStream(), (Charset)Charset.forName("UTF-8"));
            FsProjectStorage.storeBootstrapInfo((String)bootstrapInfo, (String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
            return this.buildOkResponse();
        }
        catch (StorageException e) {
            return this.buildErrorResponse(Response.Status.OK, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
        catch (IOException e) {
            return this.buildErrorResponse(Response.Status.OK, RvdResponse.Status.ERROR, new RvdException("Error reading from request stream", (Throwable)e));
        }
    }

    @GET
    @Path(value="apps/{applicationSid}/bootstrap")
    public Response getBootstrap(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        try {
            if (!FsProjectStorage.hasBootstrapInfo((String)applicationSid, (WorkspaceStorage)this.workspaceStorage)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String bootstrapInfo = FsProjectStorage.loadBootstrapInfo((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
            return Response.ok((Object)bootstrapInfo, (String)"application/json").build();
        }
        catch (StorageException e) {
            logger.error((Object)e, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

