/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.ProjectAwareRvdContext;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.exceptions.AccessApiException;
import org.restcomm.connect.rvd.exceptions.callcontrol.CallControlBadRequestException;
import org.restcomm.connect.rvd.exceptions.callcontrol.CallControlException;
import org.restcomm.connect.rvd.exceptions.callcontrol.CallControlInvalidConfigurationException;
import org.restcomm.connect.rvd.exceptions.callcontrol.UnauthorizedCallControlAccess;
import org.restcomm.connect.rvd.http.resources.SecuredRestService;
import org.restcomm.connect.rvd.identity.AccountProvider;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.interpreter.exceptions.RemoteServiceError;
import org.restcomm.connect.rvd.model.CallControlInfo;
import org.restcomm.connect.rvd.model.ModelMarshaler;
import org.restcomm.connect.rvd.model.ProjectSettings;
import org.restcomm.connect.rvd.model.UserProfile;
import org.restcomm.connect.rvd.model.callcontrol.CallControlAction;
import org.restcomm.connect.rvd.model.callcontrol.CallControlStatus;
import org.restcomm.connect.rvd.model.client.StateHeader;
import org.restcomm.connect.rvd.restcomm.RestcommAccountInfo;
import org.restcomm.connect.rvd.restcomm.RestcommCall;
import org.restcomm.connect.rvd.restcomm.RestcommCallArray;
import org.restcomm.connect.rvd.restcomm.RestcommClient;
import org.restcomm.connect.rvd.storage.FsCallControlInfoStorage;
import org.restcomm.connect.rvd.storage.FsProfileDao;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageEntityNotFound;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.storage.exceptions.WavItemDoesNotExist;
import org.restcomm.connect.rvd.utils.RvdUtils;

@Path(value="apps")
public class RvdController
extends SecuredRestService {
    static final Logger logger = Logger.getLogger((String)RvdController.class.getName());
    private RvdConfiguration rvdSettings;
    private ProjectAwareRvdContext rvdContext;
    private WorkspaceStorage workspaceStorage;
    private ModelMarshaler marshaler;

    @PostConstruct
    public void init() {
        super.init();
        this.rvdContext = new ProjectAwareRvdContext(this.request, this.servletContext, this.applicationContext.getConfiguration());
        this.rvdSettings = this.rvdContext.getSettings();
        this.marshaler = this.rvdContext.getMarshaler();
        this.workspaceStorage = this.rvdContext.getWorkspaceStorage();
    }

    public RvdController() {
    }

    RvdController(UserIdentityContext context) {
        super(context);
    }

    private Response runInterpreter(String appname, HttpServletRequest httpRequest, MultivaluedMap<String, String> requestParams) {
        String rcmlResponse;
        try {
            if (!FsProjectStorage.projectExists((String)appname, (WorkspaceStorage)this.workspaceStorage)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String targetParam = (String)requestParams.getFirst((Object)"target");
            Interpreter interpreter = new Interpreter(this.rvdContext, targetParam, appname, httpRequest, requestParams, this.workspaceStorage, this.applicationContext);
            rcmlResponse = interpreter.interpret();
            ProjectSettings projectSettings = this.rvdContext.getProjectSettings();
            if (projectSettings.getLogging().booleanValue() && projectSettings.getLoggingRCML() != null && projectSettings.getLoggingRCML().booleanValue()) {
                interpreter.getProjectLogger().log((Object)rcmlResponse, false).tag("app", appname).tag("RCML").done();
            }
        }
        catch (RemoteServiceError e) {
            logger.warn((Object)e.getMessage());
            if (this.rvdContext.getProjectSettings().getLogging().booleanValue()) {
                this.rvdContext.getProjectLogger().log((Object)e.getMessage()).tag("app", appname).tag("EXCEPTION").done();
            }
            rcmlResponse = Interpreter.rcmlOnException();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (this.rvdContext.getProjectSettings().getLogging().booleanValue()) {
                this.rvdContext.getProjectLogger().log((Object)e.getMessage()).tag("app", appname).tag("EXCEPTION").done();
            }
            rcmlResponse = Interpreter.rcmlOnException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)rcmlResponse);
        }
        return Response.ok((Object)rcmlResponse, (String)"application/xml").build();
    }

    @GET
    @Path(value="{appname}/controller")
    @Produces(value={"application/xml"})
    public Response controllerGet(@PathParam(value="appname") String appname, @Context HttpServletRequest httpRequest, @Context UriInfo ui) {
        this.rvdContext.setProjectName(appname);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Received Restcomm GET request");
        }
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
        }
        if (logger.isInfoEnabled()) {
            logger.debug((Object)(httpRequest.getMethod() + " - " + httpRequest.getRequestURI() + " - " + httpRequest.getQueryString()));
        }
        MultivaluedMap requestParams = ui.getQueryParameters();
        return this.runInterpreter(appname, httpRequest, requestParams);
    }

    @POST
    @Path(value="{appname}/controller")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/xml"})
    public Response controllerPost(@PathParam(value="appname") String appname, @Context HttpServletRequest httpRequest, MultivaluedMap<String, String> requestParams) {
        this.rvdContext.setProjectName(appname);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Received Restcomm POST request");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(httpRequest.getMethod() + " - " + httpRequest.getRequestURI() + " - " + httpRequest.getQueryString()));
            logger.debug((Object)("POST Params: " + requestParams.toString()));
        }
        return this.runInterpreter(appname, httpRequest, requestParams);
    }

    @GET
    @Path(value="{appname}/resources/{filename}")
    public Response getWav(@PathParam(value="appname") String projectName, @PathParam(value="filename") String filename) {
        this.rvdContext.setProjectName(projectName);
        try {
            InputStream wavStream = FsProjectStorage.getWav((String)projectName, (String)filename, (WorkspaceStorage)this.workspaceStorage);
            return Response.ok((Object)wavStream, (String)"audio/x-wav").header("Content-Disposition", (Object)("attachment; filename = " + filename)).build();
        }
        catch (WavItemDoesNotExist e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private RestcommCallArray executeAction(String projectName, HttpServletRequest request, String toParam, String fromParam, String accessToken, UriInfo ui, AccountProvider accountProvider) throws StorageException, CallControlException {
        String from;
        String to;
        URIBuilder uriBuilder;
        String rcmlUrl;
        RestcommClient restcommClient;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("WebTrigger: Application '" + projectName + "' initiated. User request URL: " + ui.getRequestUri().toString()));
        }
        if (this.rvdContext.getProjectSettings().getLogging().booleanValue()) {
            this.rvdContext.getProjectLogger().log((Object)("WebTrigger incoming request: " + ui.getRequestUri().toString()), false).tag("app", projectName).tag("WebTrigger").done();
        }
        CallControlInfo info = FsCallControlInfoStorage.loadInfo((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        StateHeader projectHeader = FsProjectStorage.loadStateHeader((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        String owner = projectHeader.getOwner();
        if (RvdUtils.isEmpty((String)owner)) {
            throw new CallControlException("Project '" + projectName + "' has no owner and can't be started using WebTrigger.");
        }
        String effectiveAuthHeader = null;
        String accountSid = null;
        if (!RvdUtils.isEmpty((String)info.accessToken) && !RvdUtils.isEmpty((String)accessToken)) {
            if (!info.accessToken.equals(accessToken)) {
                throw new UnauthorizedCallControlAccess("WebTrigger authorization error");
            }
            FsProfileDao profileDao = new FsProfileDao(this.workspaceStorage);
            UserProfile profile = profileDao.loadUserProfile(owner);
            if (profile == null) {
                throw new UnauthorizedCallControlAccess("No user profile found for user '" + owner + "'. Web trigger cannot be used for project belonging to this user.");
            }
            effectiveAuthHeader = RvdUtils.isEmpty((String)profile.getUsername()) ? null : "Basic " + RvdUtils.buildHttpAuthorizationToken((String)profile.getUsername(), (String)profile.getToken());
            RestcommAccountInfo accountInfo = (RestcommAccountInfo)accountProvider.getActiveAccount(profile.getUsername(), effectiveAuthHeader).get();
            if (accountInfo == null) {
                throw new UnauthorizedCallControlAccess("WebTrigger authorization error");
            }
            accountSid = accountInfo.getSid();
        }
        if (effectiveAuthHeader == null && this.getUserIdentityContext().getAccountInfo() != null) {
            effectiveAuthHeader = this.getUserIdentityContext().getEffectiveAuthorizationHeader();
            accountSid = this.getUserIdentityContext().getAccountInfo().getSid();
        }
        if (effectiveAuthHeader == null) {
            throw new UnauthorizedCallControlAccess("WebTrigger authorization error");
        }
        URI restcommBaseUri = this.applicationContext.getConfiguration().getRestcommBaseUri();
        try {
            restcommClient = new RestcommClient(restcommBaseUri, effectiveAuthHeader, this.applicationContext.getHttpClientBuilder());
        }
        catch (RestcommClient.RestcommClientInitializationException e) {
            throw new CallControlException("WebTrigger", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WebTrigger: reaching restcomm at '" + restcommBaseUri + "'"));
        }
        if (RvdUtils.isEmpty((String)(rcmlUrl = ((CallControlInfo.Lane)info.lanes.get((int)0)).startPoint.rcmlUrl))) {
            uriBuilder = new URIBuilder(restcommBaseUri);
            uriBuilder.setPath("/restcomm-rvd/services/apps/" + projectName + "/controller");
            try {
                rcmlUrl = uriBuilder.build().toString();
            }
            catch (URISyntaxException e) {
                throw new CallControlException("URI parsing error while generating the rcml url", (Throwable)e);
            }
        }
        try {
            uriBuilder = new URIBuilder(rcmlUrl);
            MultivaluedMap requestParams = ui.getQueryParameters();
            for (String paramName : requestParams.keySet()) {
                if ("token".equals(paramName) || "from".equals(paramName) || "to".equals(paramName)) continue;
                RvdController rvdController = this;
                if (rvdController.rvdSettings.getRestcommParameterNames().contains(paramName)) continue;
                uriBuilder.addParameter(Interpreter.nameModuleRequestParam((String)paramName), (String)requestParams.getFirst((Object)paramName));
            }
            rcmlUrl = uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new CallControlException("Error copying user supplied parameters to rcml url", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WebTrigger: rcmlUrl: " + rcmlUrl));
        }
        if (RvdUtils.isEmpty((String)(to = toParam))) {
            to = ((CallControlInfo.Lane)info.lanes.get((int)0)).startPoint.to;
        }
        if (RvdUtils.isEmpty((String)(from = fromParam))) {
            from = ((CallControlInfo.Lane)info.lanes.get((int)0)).startPoint.from;
        }
        if (RvdUtils.isEmpty((String)from) && !RvdUtils.isEmpty((String)projectName)) {
            from = projectName.substring(0, projectName.length() < 10 ? projectName.length() : 10);
        }
        if (RvdUtils.isEmpty((String)rcmlUrl)) {
            throw new CallControlInvalidConfigurationException("Could not determine application RCML url.");
        }
        if (RvdUtils.isEmpty((String)from) || RvdUtils.isEmpty((String)to)) {
            throw new CallControlBadRequestException("Either <i>from</i> or <i>to</i> value is missing. Make sure they are both passed as query parameters or are defined in the Web Trigger configuration.").setStatusCode(Integer.valueOf(400));
        }
        try {
            if (RvdUtils.isEmpty((String)accountSid)) {
                RestcommAccountInfo accountResponse = (RestcommAccountInfo)restcommClient.get("/restcomm/2012-04-24/Accounts.json/" + this.getLoggedUsername()).done(this.marshaler.getGson(), RestcommAccountInfo.class);
                accountSid = accountResponse.getSid();
            }
            RestcommCallArray response = (RestcommCallArray)restcommClient.post("/restcomm/2012-04-24/Accounts/" + accountSid + "/Calls.json").addParam("From", from).addParam("To", to).addParam("Url", rcmlUrl).done(this.marshaler.getGson(), RestcommCallArray.class);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("WebTrigger: joined " + to + " with " + rcmlUrl));
            }
            return response;
        }
        catch (AccessApiException e) {
            throw new CallControlException(e.getMessage(), (Throwable)e).setStatusCode(e.getStatusCode());
        }
    }

    @GET
    @Path(value="{appname}/start{extension: (.html)?}")
    @Produces(value={"text/html"})
    public Response executeActionHtml(@PathParam(value="appname") String projectName, @Context HttpServletRequest request, @QueryParam(value="to") String toParam, @QueryParam(value="from") String fromParam, @QueryParam(value="token") String accessToken, @Context UriInfo ui) {
        String selectedMediaType = "text/html";
        try {
            this.rvdContext.setProjectName(projectName);
            AccountProvider accountProvider = this.applicationContext.getAccountProvider();
            RestcommCallArray calls = this.executeAction(projectName, request, toParam, fromParam, accessToken, ui, accountProvider);
            StringBuffer messageBuffer = new StringBuffer("[");
            for (int i = 0; i < calls.size(); ++i) {
                messageBuffer.append(((RestcommCall)calls.get(i)).getSid());
                if (i >= calls.size() - 1) continue;
                messageBuffer.append(",");
            }
            messageBuffer.append("]");
            return this.buildWebTriggerHtmlResponse("Web Trigger", "Create call", "success", "Created call with SID " + messageBuffer.toString() + " from " + ((RestcommCall)calls.get(0)).getFrom() + " to " + ((RestcommCall)calls.get(0)).getTo(), Integer.valueOf(200));
        }
        catch (UnauthorizedCallControlAccess e) {
            logger.warn((Object)e);
            return this.buildWebTriggerHtmlResponse("Web Trigger", "Create call", "failure", "Authentication error", Integer.valueOf(401));
        }
        catch (CallControlException e) {
            logger.error((Object)"", (Throwable)e);
            int httpStatus = 500;
            if (e.getStatusCode() != null) {
                httpStatus = e.getStatusCode();
            }
            return this.buildWebTriggerHtmlResponse("Web Trigger", "Create call", "failure", "", Integer.valueOf(httpStatus));
        }
        catch (StorageEntityNotFound e) {
            logger.error((Object)"", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (StorageException e) {
            logger.error((Object)"", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(selectedMediaType).build();
        }
    }

    @GET
    @Path(value="{appname}/start.json")
    @Produces(value={"application/json"})
    public Response executeActionJson(@PathParam(value="appname") String projectName, @Context HttpServletRequest request, @QueryParam(value="to") String toParam, @QueryParam(value="from") String fromParam, @QueryParam(value="token") String accessToken, @Context UriInfo ui) {
        String selectedMediaType = "application/json";
        try {
            this.rvdContext.setProjectName(projectName);
            AccountProvider accountProvider = this.applicationContext.getAccountProvider();
            RestcommCallArray calls = this.executeAction(projectName, request, toParam, fromParam, accessToken, ui, accountProvider);
            return this.buildWebTriggerJsonResponse(CallControlAction.createCall, CallControlStatus.success, Integer.valueOf(200), (Object)calls);
        }
        catch (UnauthorizedCallControlAccess e) {
            logger.warn((Object)e);
            return this.buildWebTriggerJsonResponse(CallControlAction.createCall, CallControlStatus.failure, Integer.valueOf(401), null);
        }
        catch (CallControlException e) {
            logger.error((Object)"", (Throwable)e);
            int httpStatus = 500;
            if (e.getStatusCode() != null) {
                httpStatus = e.getStatusCode();
            }
            return this.buildWebTriggerJsonResponse(CallControlAction.createCall, CallControlStatus.failure, Integer.valueOf(httpStatus), null);
        }
        catch (StorageEntityNotFound e) {
            logger.error((Object)"", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (StorageException e) {
            logger.error((Object)"", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(selectedMediaType).build();
        }
    }

    @GET
    @Path(value="{appname}/log")
    public Response appLog(@PathParam(value="appname") String appName) {
        this.secure();
        try {
            this.rvdContext.setProjectName(appName);
            ProjectSettings projectSettings = FsProjectStorage.loadProjectSettings((String)appName, (WorkspaceStorage)this.workspaceStorage);
            if (projectSettings == null || !projectSettings.getLogging().booleanValue()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            try {
                FileInputStream logStream = new FileInputStream(this.rvdContext.getProjectLogger().getLogFilePath());
                return Response.ok((Object)logStream, (String)"text/plain").header("Cache-Control", (Object)"no-cache, no-store, must-revalidate").header("Pragma", (Object)"no-cache").build();
            }
            catch (FileNotFoundException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        catch (StorageEntityNotFound e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (StorageException e1) {
            logger.error((Object)e1, (Throwable)e1);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="{appname}/log")
    public Response resetAppLog(@PathParam(value="appname") String appName) {
        this.secure();
        try {
            this.rvdContext.setProjectName(appName);
            ProjectSettings projectSettings = FsProjectStorage.loadProjectSettings((String)appName, (WorkspaceStorage)this.workspaceStorage);
            if (projectSettings == null || !projectSettings.getLogging().booleanValue()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            this.rvdContext.getProjectLogger().reset();
            return Response.ok().build();
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

