/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.identity;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.commons.GenericResponse;
import org.restcomm.connect.rvd.commons.http.CustomHttpClientBuilder;
import org.restcomm.connect.rvd.identity.BasicAuthCredentials;
import org.restcomm.connect.rvd.restcomm.RestcommAccountInfo;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class AccountProvider {
    String restcommUrl = null;
    private boolean restcommUrlInitialized = false;
    CustomHttpClientBuilder httpClientBuilder;
    RvdConfiguration configuration;

    public AccountProvider(String restcommUrl, CustomHttpClientBuilder httpClientBuilder) {
        if (restcommUrl == null) {
            throw new IllegalStateException("restcommUrl cannot be null");
        }
        this.restcommUrl = this.sanitizeRestcommUrl(restcommUrl);
        this.restcommUrlInitialized = true;
        this.httpClientBuilder = httpClientBuilder;
    }

    public AccountProvider(RvdConfiguration configuration, CustomHttpClientBuilder httpClientBuilder) {
        this.configuration = configuration;
        this.httpClientBuilder = httpClientBuilder;
    }

    private String getRestcommUrl() {
        if (!this.restcommUrlInitialized) {
            URI uriFromConfig = this.configuration.getRestcommBaseUri();
            if (uriFromConfig == null) {
                throw new IllegalStateException("restcommUrl cannot be null");
            }
            String url = uriFromConfig.toString();
            this.restcommUrl = this.sanitizeRestcommUrl(url);
            this.restcommUrlInitialized = true;
        }
        return this.restcommUrl;
    }

    private String sanitizeRestcommUrl(String restcommUrl) {
        if ((restcommUrl = restcommUrl.trim()).endsWith("/")) {
            return restcommUrl.substring(0, restcommUrl.length() - 1);
        }
        return restcommUrl;
    }

    private URI buildAccountQueryUrl(String usernameOrSid) {
        try {
            URI uri = new URIBuilder(this.getRestcommUrl()).setPath("/restcomm/2012-04-24/Accounts.json/" + usernameOrSid).build();
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public GenericResponse<RestcommAccountInfo> getAccount(String accountName, String authorizationHeader) {
        block4: {
            CloseableHttpClient client = this.httpClientBuilder.buildHttpClient();
            HttpGet GETRequest = new HttpGet(this.buildAccountQueryUrl(accountName));
            GETRequest.addHeader("Authorization", authorizationHeader);
            try {
                CloseableHttpResponse response = client.execute((HttpUriRequest)GETRequest);
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        String accountJson = EntityUtils.toString((HttpEntity)entity);
                        Gson gson = new Gson();
                        RestcommAccountInfo accountResponse = (RestcommAccountInfo)gson.fromJson(accountJson, RestcommAccountInfo.class);
                        return new GenericResponse((Object)accountResponse);
                    }
                    break block4;
                }
                return new GenericResponse(Integer.valueOf(response.getStatusLine().getStatusCode()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new GenericResponse("Something went wrong while retrieving account " + accountName);
    }

    public GenericResponse<RestcommAccountInfo> getActiveAccount(String accountName, String authorizationHeader) {
        GenericResponse response = this.getAccount(accountName, authorizationHeader);
        if (!"active".equals(((RestcommAccountInfo)response.get()).getStatus())) {
            return new GenericResponse("Account is not active");
        }
        return response;
    }

    public GenericResponse<RestcommAccountInfo> getActiveAccount(BasicAuthCredentials creds) {
        String header = "Basic " + RvdUtils.buildHttpAuthorizationToken((String)creds.getUsername(), (String)creds.getPassword());
        return this.getActiveAccount(creds.getUsername(), header);
    }
}

