/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.jsonvalidation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.restcomm.connect.rvd.jsonvalidation.ValidationResult;

public class ValidationResult {
    private ProcessingReport report;
    private boolean success;
    private List<ErrorItem> errorItems = new ArrayList();

    public ValidationResult(ProcessingReport report) {
        this.report = report;
        this.success = report.isSuccess();
        Iterator i = report.iterator();
        while (i.hasNext()) {
            JsonNode node = ((ProcessingMessage)i.next()).asJson();
            ErrorItem item = new ErrorItem();
            item.level = node.get("level").asText();
            item.failurePath = node.get("instance").get("pointer").asText();
            item.summary = node.get("message").asText();
            this.errorItems.add(item);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<ErrorItem> getErrorItems() {
        return this.errorItems;
    }

    public ProcessingReport getReport() {
        return this.report;
    }
}

