/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.gather;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.interpreter.Target;
import org.restcomm.connect.rvd.model.client.Step;
import org.restcomm.connect.rvd.model.steps.gather.GatherStep;
import org.restcomm.connect.rvd.model.steps.gather.RcmlGatherStep;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;

/*
 * Exception performing whole class analysis ignored.
 */
public class GatherStep
extends Step {
    static final Logger logger = Logger.getLogger((String)GatherStep.class.getName());
    private String action;
    private String method;
    private Integer timeout;
    private String finishOnKey;
    private Integer numDigits;
    private List<Step> steps;
    private Validation validation;
    private Step invalidMessage;
    private Menu menu;
    private Collectdigits collectdigits;
    private String gatherType;

    public RcmlGatherStep render(Interpreter interpreter) throws InterpreterException {
        RcmlGatherStep rcmlStep = new RcmlGatherStep();
        String newtarget = interpreter.getTarget().getNodename() + "." + this.getName() + ".handle";
        HashMap<String, String> pairs = new HashMap<String, String>();
        pairs.put("target", newtarget);
        String action = interpreter.buildAction(pairs);
        rcmlStep.setAction(action);
        rcmlStep.setTimeout(this.timeout);
        if (this.finishOnKey != null && !"".equals(this.finishOnKey)) {
            rcmlStep.setFinishOnKey(this.finishOnKey);
        }
        rcmlStep.setMethod(this.method);
        rcmlStep.setNumDigits(this.numDigits);
        for (Step nestedStep : this.steps) {
            rcmlStep.getSteps().add(nestedStep.render(interpreter));
        }
        return rcmlStep;
    }

    public void handleAction(Interpreter interpreter, Target originTarget) throws InterpreterException, StorageException {
        String digitsString;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"handling gather action");
        }
        if ((digitsString = (String)interpreter.getRequestParams().getFirst((Object)"Digits")) != null) {
            interpreter.getVariables().put("core_Digits", digitsString);
        }
        boolean valid = true;
        if ("menu".equals(this.gatherType)) {
            boolean handled = false;
            for (Mapping mapping : Menu.access$000((Menu)this.menu)) {
                String digits = digitsString;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("checking digits: " + Mapping.access$100((Mapping)mapping) + " - " + digits));
                }
                if (Mapping.access$100((Mapping)mapping) == null || !Mapping.access$100((Mapping)mapping).equals(digits)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"seems we found out menu selection");
                }
                interpreter.interpret(Mapping.access$200((Mapping)mapping), null, null, originTarget);
                handled = true;
            }
            if (!handled) {
                valid = false;
            }
        } else if ("collectdigits".equals(this.gatherType)) {
            String variableName = Collectdigits.access$300((Collectdigits)this.collectdigits);
            String variableValue = (String)interpreter.getRequestParams().getFirst((Object)"Digits");
            if (variableValue == null) {
                logger.warn((Object)"'Digits' parameter was null. Is this a valid restcomm request?");
                variableValue = "";
            }
            boolean doValidation = false;
            if (this.validation != null) {
                String effectivePattern = null;
                if (Validation.access$400((Validation)this.validation) != null) {
                    String expandedUserPattern = interpreter.populateVariables(Validation.access$400((Validation)this.validation));
                    effectivePattern = "^[" + expandedUserPattern + "]$";
                } else if (Validation.access$500((Validation)this.validation) != null) {
                    String expandedRegexPattern;
                    effectivePattern = expandedRegexPattern = interpreter.populateVariables(Validation.access$500((Validation)this.validation));
                } else {
                    logger.warn((Object)"Invalid validation information in gather. Validation object exists while oth patterns are null");
                }
                if (effectivePattern != null) {
                    doValidation = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Validating '" + variableValue + "' against " + effectivePattern));
                    }
                    if (!variableValue.matches(effectivePattern)) {
                        valid = false;
                    }
                }
            }
            if (doValidation && !valid) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Invalid input for gather/collectdigits. Will say the validation message and rerun the gather");
                }
            } else {
                if ("application".equals(Collectdigits.access$600((Collectdigits)this.collectdigits))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("'" + variableName + "' is application scoped"));
                    }
                    interpreter.putStickyVariable(variableName, variableValue);
                } else if ("module".equals(Collectdigits.access$600((Collectdigits)this.collectdigits))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("'" + variableName + "' is module scoped"));
                    }
                    interpreter.putModuleVariable(variableName, variableValue);
                }
                interpreter.getVariables().put(variableName, variableValue);
                interpreter.interpret(Collectdigits.access$700((Collectdigits)this.collectdigits), null, null, originTarget);
            }
        }
        if (!valid) {
            interpreter.interpret(interpreter.getTarget().getNodename() + "." + interpreter.getTarget().getStepname(), null, this.invalidMessage != null ? this.invalidMessage : null, originTarget);
        }
    }
}

