/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.storage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.restcomm.connect.rvd.exceptions.ProjectDoesNotExist;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.exceptions.packaging.AppPackageDoesNotExist;
import org.restcomm.connect.rvd.model.packaging.Rapp;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;

public class FsPackagingStorage {
    public static Rapp loadRapp(String projectName, WorkspaceStorage storage) throws StorageException {
        return (Rapp)storage.loadEntity("rapp", projectName + "/" + "packaging", Rapp.class);
    }

    public static void storeRapp(Rapp rapp, String projectName, WorkspaceStorage storage) throws StorageException {
        storage.storeEntity((Object)rapp, rapp.getClass(), "rapp", projectName + "/" + "packaging");
    }

    public static void storeRappBinary(File sourceFile, String projectName, WorkspaceStorage storage) throws RvdException {
        storage.storeBinaryFile(sourceFile, "app.zip", projectName + "/" + "packaging");
    }

    public static InputStream getRappBinary(String projectName, WorkspaceStorage storage) throws AppPackageDoesNotExist {
        try {
            return storage.loadBinaryFile(projectName, "app.zip", projectName + "/" + "packaging");
        }
        catch (FileNotFoundException e) {
            throw new AppPackageDoesNotExist("Binary package does not exist for project " + projectName);
        }
    }

    public static boolean hasPackaging(String projectName, WorkspaceStorage storage) throws ProjectDoesNotExist {
        return storage.entityExists("packaging", projectName);
    }

    public static boolean binaryAvailable(String projectName, WorkspaceStorage storage) {
        return storage.entityExists("app.zip", projectName + "/" + "packaging");
    }
}

