/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.storage;

import org.restcomm.connect.rvd.model.UserProfile;
import org.restcomm.connect.rvd.storage.ProfileDao;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageEntityNotFound;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;

public class FsProfileDao
implements ProfileDao {
    private WorkspaceStorage workspaceStorage;

    public FsProfileDao(WorkspaceStorage workspaceStorage) {
        this.workspaceStorage = workspaceStorage;
    }

    public void saveUserProfile(String username, UserProfile userProfile) {
        try {
            this.workspaceStorage.storeEntity((Object)userProfile, UserProfile.class, username, "@users");
        }
        catch (StorageException e) {
            throw new RuntimeException("Error storing profile for user '" + username + "'", e);
        }
    }

    public UserProfile loadUserProfile(String username) {
        try {
            UserProfile profile = (UserProfile)this.workspaceStorage.loadEntity(username, "@users", UserProfile.class);
            return profile;
        }
        catch (StorageEntityNotFound e) {
            return null;
        }
        catch (StorageException e) {
            throw new RuntimeException("Error loading profile for user '" + username + "'", e);
        }
    }
}

