/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.net.URI;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.dao.Sid;

@Immutable
public final class Account {
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String emailAddress;
    private final String friendlyName;
    private final Sid parentSid;
    private final Type type;
    private final Status status;
    private final String authToken;
    private final String role;
    private final URI uri;

    public Account(Sid sid, DateTime dateCreated, DateTime dateUpdated, String emailAddress, String friendlyName, Sid parentSid, Type type, Status status, String authToken, String role, URI uri) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.emailAddress = emailAddress;
        this.friendlyName = friendlyName;
        this.parentSid = parentSid;
        this.type = type;
        this.status = status;
        this.authToken = authToken;
        this.role = role;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public Sid getParentSid() {
        return this.parentSid;
    }

    public Type getType() {
        return this.type;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getRole() {
        return this.role;
    }

    public URI getUri() {
        return this.uri;
    }

    public Account setEmailAddress(String emailAddress) {
        return new Account(this.sid, this.dateCreated, DateTime.now(), emailAddress, this.friendlyName, this.parentSid, this.type, this.status, this.authToken, this.role, this.uri);
    }

    public Account setFriendlyName(String friendlyName) {
        return new Account(this.sid, this.dateCreated, DateTime.now(), this.emailAddress, friendlyName, this.parentSid, this.type, this.status, this.authToken, this.role, this.uri);
    }

    public Account setType(Type type) {
        return new Account(this.sid, this.dateCreated, DateTime.now(), this.emailAddress, this.friendlyName, this.parentSid, type, this.status, this.authToken, this.role, this.uri);
    }

    public Account setStatus(Status status) {
        return new Account(this.sid, this.dateCreated, DateTime.now(), this.emailAddress, this.friendlyName, this.parentSid, this.type, status, this.authToken, this.role, this.uri);
    }

    public Account setAuthToken(String authToken) {
        return new Account(this.sid, this.dateCreated, DateTime.now(), this.emailAddress, this.friendlyName, this.parentSid, this.type, this.status, authToken, this.role, this.uri);
    }

    public Account setRole(String role) {
        return new Account(this.sid, this.dateCreated, DateTime.now(), this.emailAddress, this.friendlyName, this.parentSid, this.type, this.status, this.authToken, role, this.uri);
    }

    public static final class Builder {
        private Sid sid;
        private String emailAddress;
        private String friendlyName;
        private Sid parentSid;
        private Type type;
        private Status status;
        private String authToken;
        private String role;
        private URI uri;

        private Builder() {
        }

        public Account build() {
            DateTime now = DateTime.now();
            return new Account(this.sid, now, now, this.emailAddress, this.friendlyName, this.parentSid, this.type, this.status, this.authToken, this.role, this.uri);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public void setParentSid(Sid parentSid) {
            this.parentSid = parentSid;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }

    public static enum Type {
        FULL("Full"),
        TRIAL("Trial");

        private final String text;

        private Type(String text) {
            this.text = text;
        }

        public static Type getValueOf(String text) {
            Type[] values;
            for (Type value : values = Type.values()) {
                if (!value.text.equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid account type.");
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Status {
        ACTIVE("active"),
        CLOSED("closed"),
        SUSPENDED("suspended"),
        INACTIVE("inactive"),
        UNINITIALIZED("uninitialized");

        private final String text;

        private Status(String text) {
            this.text = text;
        }

        public static Status getValueOf(String text) {
            Status[] values;
            for (Status value : values = Status.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid account status.");
        }

        public String toString() {
            return this.text;
        }
    }
}

