/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.net.URI;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.dao.Sid;

@Immutable
public final class Application {
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final Sid accountSid;
    private final String apiVersion;
    private final Boolean hasVoiceCallerIdLookup;
    private final URI uri;
    private final URI rcmlUrl;
    private final Kind kind;

    public Application(Sid sid, DateTime dateCreated, DateTime dateUpdated, String friendlyName, Sid accountSid, String apiVersion, Boolean hasVoiceCallerIdLookup, URI uri, URI rcmlUrl, Kind kind) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.friendlyName = friendlyName;
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.hasVoiceCallerIdLookup = hasVoiceCallerIdLookup;
        this.uri = uri;
        this.rcmlUrl = rcmlUrl;
        this.kind = kind;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Boolean hasVoiceCallerIdLookup() {
        return this.hasVoiceCallerIdLookup;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getRcmlUrl() {
        return this.rcmlUrl;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Application setFriendlyName(String friendlyName) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), friendlyName, this.accountSid, this.apiVersion, this.hasVoiceCallerIdLookup, this.uri, this.rcmlUrl, this.kind);
    }

    public Application setVoiceCallerIdLookup(boolean hasVoiceCallerIdLookup) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, hasVoiceCallerIdLookup, this.uri, this.rcmlUrl, this.kind);
    }

    public Application setRcmlUrl(URI rcmlUrl) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.hasVoiceCallerIdLookup, this.uri, rcmlUrl, this.kind);
    }

    public Application setKind(Kind kind) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.hasVoiceCallerIdLookup, this.uri, this.rcmlUrl, kind);
    }

    public static final class Builder {
        private Sid sid;
        private String friendlyName;
        private Sid accountSid;
        private String apiVersion;
        private Boolean hasVoiceCallerIdLookup;
        private URI uri;
        private URI rcmlUrl;
        private Kind kind;

        private Builder() {
        }

        public Application build() {
            DateTime now = DateTime.now();
            return new Application(this.sid, now, now, this.friendlyName, this.accountSid, this.apiVersion, this.hasVoiceCallerIdLookup, this.uri, this.rcmlUrl, this.kind);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setHasVoiceCallerIdLookup(boolean hasVoiceCallerIdLookup) {
            this.hasVoiceCallerIdLookup = hasVoiceCallerIdLookup;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public void setRcmlUrl(URI rcmlUrl) {
            this.rcmlUrl = rcmlUrl;
        }

        public void setKind(Kind kind) {
            this.kind = kind;
        }
    }

    public static enum Kind {
        VOICE("voice"),
        SMS("sms"),
        USSD("ussd");

        private final String text;

        private Kind(String text) {
            this.text = text;
        }

        public static Kind getValueOf(String text) {
            Kind[] values;
            for (Kind value : values = Kind.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid application kind.");
        }

        public String toString() {
            return this.text;
        }
    }
}

