/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;

@Immutable
public final class CallDetailRecord {
    private final Sid sid;
    private final String instanceId;
    private final Sid parentCallSid;
    private final Sid conferenceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Sid accountSid;
    private final String to;
    private final String from;
    private final Sid phoneNumberSid;
    private final String status;
    private final DateTime startTime;
    private final DateTime endTime;
    private final Integer duration;
    private final Integer ringDuration;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final String direction;
    private final String answeredBy;
    private final String apiVersion;
    private final String forwardedFrom;
    private final String callerName;
    private final URI uri;
    private final String callPath;
    private final Boolean muted;
    private final Boolean startConferenceOnEnter;
    private final Boolean endConferenceOnExit;
    private final Boolean onHold;
    private final String msId;

    public CallDetailRecord(Sid sid, String instanceId, Sid parentCallSid, Sid conferenceSid, DateTime dateCreated, DateTime dateUpdated, Sid accountSid, String to, String from, Sid phoneNumberSid, String status, DateTime startTime, DateTime endTime, Integer duration, BigDecimal price, Currency priceUnit, String direction, String answeredBy, String apiVersion, String forwardedFrom, String callerName, URI uri, String callPath, Integer ringDuration, Boolean muted, Boolean startConferenceOnEnter, Boolean endConferenceOnExit, Boolean onHold, String msId) {
        this.sid = sid;
        this.instanceId = instanceId;
        this.parentCallSid = parentCallSid;
        this.conferenceSid = conferenceSid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.accountSid = accountSid;
        this.to = to;
        this.from = from;
        this.phoneNumberSid = phoneNumberSid;
        this.status = status;
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.price = price;
        this.priceUnit = priceUnit;
        this.direction = direction;
        this.answeredBy = answeredBy;
        this.apiVersion = apiVersion;
        this.forwardedFrom = forwardedFrom;
        this.callerName = callerName;
        this.uri = uri;
        this.callPath = callPath;
        this.ringDuration = ringDuration;
        this.muted = muted;
        this.startConferenceOnEnter = startConferenceOnEnter;
        this.endConferenceOnExit = endConferenceOnExit;
        this.onHold = onHold;
        this.msId = msId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Sid getParentCallSid() {
        return this.parentCallSid;
    }

    public Sid getConferenceSid() {
        return this.conferenceSid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public Sid getPhoneNumberSid() {
        return this.phoneNumberSid;
    }

    public String getStatus() {
        return this.status;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Integer getRingDuration() {
        return this.ringDuration;
    }

    public BigDecimal getPrice() {
        return this.price == null ? new BigDecimal("0.0") : this.price;
    }

    public Currency getPriceUnit() {
        return this.priceUnit == null ? Currency.getInstance("USD") : this.priceUnit;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getAnsweredBy() {
        return this.answeredBy;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getForwardedFrom() {
        return this.forwardedFrom;
    }

    public String getCallerName() {
        return this.callerName;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getCallPath() {
        return this.callPath;
    }

    public Boolean isMuted() {
        return this.muted;
    }

    public Boolean isStartConferenceOnEnter() {
        return this.startConferenceOnEnter;
    }

    public Boolean isEndConferenceOnExit() {
        return this.endConferenceOnExit;
    }

    public Boolean isOnHold() {
        return this.onHold;
    }

    public String getMsId() {
        return this.msId;
    }

    public CallDetailRecord setStatus(String status) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setStartTime(DateTime startTime) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setEndTime(DateTime endTime) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setDuration(Integer duration) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setRingDuration(Integer ringDuration) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setPrice(BigDecimal price) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setAnsweredBy(String answeredBy) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setConferenceSid(Sid conferenceSid) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setMuted(Boolean muted) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setStartConferenceOnEnter(Boolean startConferenceOnEnter) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setEndConferenceOnExit(Boolean endConferenceOnExit) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, endConferenceOnExit, this.onHold, this.msId);
    }

    public CallDetailRecord setOnHold(Boolean onHold) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, onHold, this.msId);
    }

    public CallDetailRecord setMsId(String msId) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, msId);
    }

    public CallDetailRecord setForwardedFrom(String forwardedFrom) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
    }

    public String toString() {
        return "CDR SID: " + this.getSid() + " | InstanceId: " + this.getInstanceId() + " | ParentCallSid: " + this.getParentCallSid() + " | ConferenceSid: " + this.getConferenceSid() + " | DateCreated: " + this.getDateCreated() + " | DateUpdated: " + this.getDateUpdated() + " | AccountSid: " + this.getAccountSid() + " | To: " + this.getTo() + " | From: " + this.getFrom() + " | PhoneNumberSid: " + this.getPhoneNumberSid() + " | Status: " + this.getStatus() + " | StartTime: " + this.getStartTime() + " | EndTime: " + this.getEndTime() + " | Duration: " + this.getDuration() + " | Price: " + this.getPrice() + " | PriceUnit: " + this.getPriceUnit() + " | Direction: " + this.getDirection() + " | AnsweredBy: " + this.getAnsweredBy() + " | ApiVersion: " + this.getApiVersion() + " | ForwaredFrom: " + this.getForwardedFrom() + " | CallerName: " + this.getCallerName() + " | Uri: " + this.getUri() + " | CallPath: " + this.getCallPath() + " | RingDuration: " + this.getRingDuration() + " | Muted: " + this.isMuted() + " | StartConferenceOnEnter: " + this.isStartConferenceOnEnter() + " | isEndConferenceOnExit: " + this.isEndConferenceOnExit() + " | isOnHold: " + this.isOnHold();
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid = null;
        private String instanceId = null;
        private Sid parentCallSid = null;
        private Sid conferenceSid = null;
        private DateTime dateCreated = null;
        private DateTime dateUpdated = DateTime.now();
        private Sid accountSid = null;
        private String to = null;
        private String from = null;
        private Sid phoneNumberSid = null;
        private String status = null;
        private DateTime startTime = null;
        private DateTime endTime = null;
        private Integer duration = null;
        private Integer ringDuration = null;
        private BigDecimal price = null;
        private Currency priceUnit;
        private String direction = null;
        private String answeredBy = null;
        private String apiVersion = null;
        private String forwardedFrom = null;
        private String callerName = null;
        private URI uri = null;
        private String callPath = null;
        private Boolean muted = null;
        private Boolean startConferenceOnEnter = null;
        private Boolean endConferenceOnExit = null;
        private Boolean onHold = null;
        private String msId = null;

        private Builder() {
        }

        public CallDetailRecord build() {
            return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.conferenceSid, this.dateCreated, this.dateUpdated, this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.startConferenceOnEnter, this.endConferenceOnExit, this.onHold, this.msId);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public void setParentCallSid(Sid parentCallSid) {
            this.parentCallSid = parentCallSid;
        }

        public void setConferenceSid(Sid conferenceSid) {
            this.conferenceSid = conferenceSid;
        }

        public void setDateCreated(DateTime dateCreated) {
            this.dateCreated = dateCreated;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setPhoneNumberSid(Sid phoneNumberSid) {
            this.phoneNumberSid = phoneNumberSid;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setStartTime(DateTime startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(DateTime endTime) {
            this.endTime = endTime;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public void setPriceUnit(Currency priceUnit) {
            this.priceUnit = priceUnit;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public void setAnsweredBy(String answeredBy) {
            this.answeredBy = answeredBy;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setForwardedFrom(String forwardedFrom) {
            this.forwardedFrom = forwardedFrom;
        }

        public void setCallerName(String callerName) {
            this.callerName = callerName;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public void setCallPath(String callPath) {
            this.callPath = callPath;
        }

        public void setMuted(Boolean muted) {
            this.muted = muted;
        }

        public void setStartConferenceOnEnter(Boolean startConferenceOnEnter) {
            this.startConferenceOnEnter = startConferenceOnEnter;
        }

        public void setEndConferenceOnExit(Boolean endConferenceOnExit) {
            this.endConferenceOnExit = endConferenceOnExit;
        }

        public void setOnHold(Boolean onHold) {
            this.onHold = onHold;
        }

        public void setMsId(String msId) {
            this.msId = msId;
        }
    }
}

