/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;

@Immutable
public class CallDetailRecordFilter {
    private final String accountSid;
    private final List<String> accountSidSet;
    private final String recipient;
    private final String sender;
    private final String status;
    private final Date startTime;
    private final Date endTime;
    private final String parentCallSid;
    private final String conferenceSid;
    private final Integer limit;
    private final Integer offset;
    private final String instanceid;

    public CallDetailRecordFilter(String accountSid, List<String> accountSidSet, String recipient, String sender, String status, String startTime, String endTime, String parentCallSid, String conferenceSid, Integer limit, Integer offset) throws ParseException {
        this(accountSid, accountSidSet, recipient, sender, status, startTime, endTime, parentCallSid, conferenceSid, limit, offset, null);
    }

    public CallDetailRecordFilter(String accountSid, List<String> accountSidSet, String recipient, String sender, String status, String startTime, String endTime, String parentCallSid, String conferenceSid, Integer limit, Integer offset, String instanceId) throws ParseException {
        Date date;
        SimpleDateFormat parser;
        this.accountSid = accountSid;
        this.accountSidSet = accountSidSet;
        if (recipient != null) {
            recipient = "%".concat(recipient);
        }
        if (sender != null) {
            sender = "%".concat(sender);
        }
        this.recipient = recipient;
        this.sender = sender;
        this.status = status;
        this.parentCallSid = parentCallSid;
        this.conferenceSid = conferenceSid;
        this.limit = limit;
        this.offset = offset;
        if (startTime != null) {
            parser = new SimpleDateFormat("yyyy-MM-dd");
            this.startTime = date = parser.parse(startTime);
        } else {
            this.startTime = null;
        }
        if (endTime != null) {
            parser = new SimpleDateFormat("yyyy-MM-dd");
            this.endTime = date = parser.parse(endTime);
        } else {
            this.endTime = null;
        }
        this.instanceid = instanceId != null && !instanceId.isEmpty() ? instanceId : null;
    }

    public String getSid() {
        return this.accountSid;
    }

    public List<String> getAccountSidSet() {
        return this.accountSidSet;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getSender() {
        return this.sender;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getParentCallSid() {
        return this.parentCallSid;
    }

    public String getConferenceSid() {
        return this.conferenceSid;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getInstanceid() {
        return this.instanceid;
    }
}

