/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.net.URI;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;

@Immutable
public final class ConferenceDetailRecord {
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Sid accountSid;
    private final String status;
    private final String friendlyName;
    private final String apiVersion;
    private final URI uri;
    private final String masterMsId;
    private final boolean masterPresent;
    private final String masterConfernceEndpointId;
    private final String masterIVREndpointId;
    private final String masterIVREndpointSessionId;
    private final String masterBridgeEndpointId;
    private final String masterBridgeEndpointSessionId;
    private final String masterBridgeConnectionIdentifier;
    private final String masterIVRConnectionIdentifier;
    private final boolean moderatorPresent;

    public ConferenceDetailRecord(Sid sid, DateTime dateCreated, DateTime dateUpdated, Sid accountSid, String status, String friendlyName, String apiVersion, URI uri, String msId, String masterConfernceEndpointId, boolean isMasterPresent, String masterIVREndpointId, String masterIVREndpointSessionId, String masterBridgeEndpointId, String masterBridgeEndpointSessionId, String masterBridgeConnectionIdentifier, String masterIVRConnectionIdentifier, boolean moderatorPresent) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.accountSid = accountSid;
        this.status = status;
        this.friendlyName = friendlyName;
        this.apiVersion = apiVersion;
        this.uri = uri;
        this.masterMsId = msId;
        this.masterConfernceEndpointId = masterConfernceEndpointId;
        this.masterPresent = isMasterPresent;
        this.masterIVREndpointId = masterIVREndpointId;
        this.masterIVREndpointSessionId = masterIVREndpointSessionId;
        this.masterBridgeEndpointId = masterBridgeEndpointId;
        this.masterBridgeEndpointSessionId = masterBridgeEndpointSessionId;
        this.masterBridgeConnectionIdentifier = masterBridgeConnectionIdentifier;
        this.masterIVRConnectionIdentifier = masterIVRConnectionIdentifier;
        this.moderatorPresent = moderatorPresent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public String getStatus() {
        return this.status;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getMasterMsId() {
        return this.masterMsId;
    }

    public String getMasterConferenceEndpointId() {
        return this.masterConfernceEndpointId;
    }

    public String getMasterBridgeEndpointId() {
        return this.masterBridgeEndpointId;
    }

    public String getMasterIVREndpointId() {
        return this.masterIVREndpointId;
    }

    public String getMasterIVREndpointSessionId() {
        return this.masterIVREndpointSessionId;
    }

    public String getMasterBridgeEndpointSessionId() {
        return this.masterBridgeEndpointSessionId;
    }

    public boolean isMasterPresent() {
        return this.masterPresent;
    }

    public String getMasterBridgeConnectionIdentifier() {
        return this.masterBridgeConnectionIdentifier;
    }

    public String getMasterIVRConnectionIdentifier() {
        return this.masterIVRConnectionIdentifier;
    }

    public boolean isModeratorPresent() {
        return this.moderatorPresent;
    }

    public ConferenceDetailRecord setStatus(String status) {
        return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, this.masterConfernceEndpointId, this.masterPresent, this.masterIVREndpointId, this.masterIVREndpointSessionId, this.masterBridgeEndpointId, this.masterBridgeEndpointSessionId, this.masterBridgeConnectionIdentifier, this.masterIVRConnectionIdentifier, this.moderatorPresent);
    }

    public ConferenceDetailRecord setMasterConfernceEndpointId(String masterConfernceEndpointId) {
        return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, masterConfernceEndpointId, this.masterPresent, this.masterIVREndpointId, this.masterIVREndpointSessionId, this.masterBridgeEndpointId, this.masterBridgeEndpointSessionId, this.masterBridgeConnectionIdentifier, this.masterIVRConnectionIdentifier, this.moderatorPresent);
    }

    public ConferenceDetailRecord setMasterIVREndpointId(String masterIVREndpointId) {
        return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, this.masterConfernceEndpointId, this.masterPresent, masterIVREndpointId, this.masterIVREndpointSessionId, this.masterBridgeEndpointId, this.masterBridgeEndpointSessionId, this.masterBridgeConnectionIdentifier, this.masterIVRConnectionIdentifier, this.moderatorPresent);
    }

    public ConferenceDetailRecord setMasterIVREndpointSessionId(String masterIVREndpointSessionId) {
        return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, this.masterConfernceEndpointId, this.masterPresent, this.masterIVREndpointId, masterIVREndpointSessionId, this.masterBridgeEndpointId, this.masterBridgeEndpointSessionId, this.masterBridgeConnectionIdentifier, this.masterIVRConnectionIdentifier, this.moderatorPresent);
    }

    public ConferenceDetailRecord setMasterBridgeEndpointSessionId(String masterBridgeEndpointSessionId) {
        return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, this.masterConfernceEndpointId, this.masterPresent, this.masterIVREndpointId, this.masterIVREndpointSessionId, this.masterBridgeEndpointId, masterBridgeEndpointSessionId, this.masterBridgeConnectionIdentifier, this.masterIVRConnectionIdentifier, this.moderatorPresent);
    }

    public ConferenceDetailRecord setMasterBridgeEndpointId(String masterBridgeEndpointId) {
        return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, this.masterConfernceEndpointId, this.masterPresent, this.masterIVREndpointId, this.masterIVREndpointSessionId, masterBridgeEndpointId, this.masterBridgeEndpointSessionId, this.masterBridgeConnectionIdentifier, this.masterIVRConnectionIdentifier, this.moderatorPresent);
    }

    public ConferenceDetailRecord setMasterBridgeConnectionIdentifier(String masterBridgeConnectionIdentifier) {
        return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, this.masterConfernceEndpointId, this.masterPresent, this.masterIVREndpointId, this.masterIVREndpointSessionId, this.masterBridgeEndpointId, this.masterBridgeEndpointSessionId, masterBridgeConnectionIdentifier, this.masterIVRConnectionIdentifier, this.moderatorPresent);
    }

    public ConferenceDetailRecord setMasterIVRConnectionIdentifier(String masterIVRConnectionIdentifier) {
        return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, this.masterConfernceEndpointId, this.masterPresent, this.masterIVREndpointId, this.masterIVREndpointSessionId, this.masterBridgeEndpointId, this.masterBridgeEndpointSessionId, this.masterBridgeConnectionIdentifier, masterIVRConnectionIdentifier, this.moderatorPresent);
    }

    public ConferenceDetailRecord setMasterPresent(boolean masterPresent) {
        return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, this.masterConfernceEndpointId, masterPresent, this.masterIVREndpointId, this.masterIVREndpointSessionId, this.masterBridgeEndpointId, this.masterBridgeEndpointSessionId, this.masterBridgeConnectionIdentifier, this.masterIVRConnectionIdentifier, this.moderatorPresent);
    }

    public ConferenceDetailRecord setModeratorPresent(boolean moderatorPresent) {
        return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, this.masterConfernceEndpointId, this.masterPresent, this.masterIVREndpointId, this.masterIVREndpointSessionId, this.masterBridgeEndpointId, this.masterBridgeEndpointSessionId, this.masterBridgeConnectionIdentifier, this.masterIVRConnectionIdentifier, moderatorPresent);
    }

    public String toString() {
        return "ConferenceDetailRecord [sid=" + this.sid + ", dateCreated=" + this.dateCreated + ", dateUpdated=" + this.dateUpdated + ", accountSid=" + this.accountSid + ", status=" + this.status + ", friendlyName=" + this.friendlyName + ", apiVersion=" + this.apiVersion + ", uri=" + this.uri + ", masterMsId=" + this.masterMsId + ", masterPresent=" + this.masterPresent + ", masterConfernceEndpointId=" + this.masterConfernceEndpointId + ", masterIVREndpointId=" + this.masterIVREndpointId + ", masterIVREndpointSessionId=" + this.masterIVREndpointSessionId + ", masterBridgeEndpointId=" + this.masterBridgeEndpointId + ", masterBridgeEndpointSessionId=" + this.masterBridgeEndpointSessionId + ", masterBridgeConnectionIdentifier=" + this.masterBridgeConnectionIdentifier + ", masterIVRConnectionIdentifier=" + this.masterIVRConnectionIdentifier + ", moderatorPresent=" + this.moderatorPresent + "]";
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid = null;
        private DateTime dateCreated = null;
        private Sid accountSid = null;
        private String status = null;
        private String friendlyName = null;
        private String apiVersion = null;
        private URI uri = null;
        private String masterMsId = null;
        private String masterConfernceEndpointId = null;
        private String masterIVREndpointId = null;
        private boolean isMasterPresent = true;

        private Builder() {
        }

        public ConferenceDetailRecord build() {
            return new ConferenceDetailRecord(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.status, this.friendlyName, this.apiVersion, this.uri, this.masterMsId, this.masterConfernceEndpointId, this.isMasterPresent, this.masterIVREndpointId, null, null, null, null, null, false);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setMasterMsId(String msId) {
            this.masterMsId = msId;
        }

        public void setDateCreated(DateTime dateCreated) {
            this.dateCreated = dateCreated;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public void setMasterConfernceEndpointId(String masterConfernceEndpointId) {
            this.masterConfernceEndpointId = masterConfernceEndpointId;
        }

        public void setMasterIVREndpointId(String masterIVREndpointId) {
            this.masterIVREndpointId = masterIVREndpointId;
        }
    }
}

