/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.net.URI;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;

public final class Geolocation {
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime dateExecuted;
    private final Sid accountSid;
    private final String source;
    private final String deviceIdentifier;
    private final GeolocationType geolocationType;
    private final String responseStatus;
    private final String cellId;
    private final String locationAreaCode;
    private final Integer mobileCountryCode;
    private final String mobileNetworkCode;
    private final Long networkEntityAddress;
    private final Integer ageOfLocationInfo;
    private final String deviceLatitude;
    private final String deviceLongitude;
    private final Long accuracy;
    private final String physicalAddress;
    private final String internetAddress;
    private final String formattedAddress;
    private final DateTime locationTimestamp;
    private final String eventGeofenceLatitude;
    private final String eventGeofenceLongitude;
    private final Long radius;
    private final String geolocationPositioningType;
    private final String lastGeolocationResponse;
    private final String cause;
    private final String apiVersion;
    private final URI uri;

    public Geolocation(Sid sid, DateTime dateCreated, DateTime dateUpdated, DateTime dateExecuted, Sid accountSid, String source, String deviceIdentifier, GeolocationType geolocationType, String responseStatus, String cellId, String locationAreaCode, Integer mobileCountryCode, String mobileNetworkCode, Long networkEntityAddress, Integer ageOfLocationInfo, String deviceLatitude, String deviceLongitude, Long accuracy, String physicalAddress, String internetAddress, String formattedAddress, DateTime locationTimestamp, String eventGeofenceLatitude, String eventGeofenceLongitude, Long radius, String geolocationPositioningType, String lastGeolocationResponse, String cause, String apiVersion, URI uri) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.dateExecuted = dateExecuted;
        this.accountSid = accountSid;
        this.source = source;
        this.deviceIdentifier = deviceIdentifier;
        this.geolocationType = geolocationType;
        this.responseStatus = responseStatus;
        this.cellId = cellId;
        this.locationAreaCode = locationAreaCode;
        this.mobileCountryCode = mobileCountryCode;
        this.mobileNetworkCode = mobileNetworkCode;
        this.networkEntityAddress = networkEntityAddress;
        this.ageOfLocationInfo = ageOfLocationInfo;
        this.deviceLatitude = deviceLatitude;
        this.deviceLongitude = deviceLongitude;
        this.accuracy = accuracy;
        this.physicalAddress = physicalAddress;
        this.internetAddress = internetAddress;
        this.formattedAddress = formattedAddress;
        this.locationTimestamp = locationTimestamp;
        this.eventGeofenceLatitude = eventGeofenceLatitude;
        this.eventGeofenceLongitude = eventGeofenceLongitude;
        this.radius = radius;
        this.geolocationPositioningType = geolocationPositioningType;
        this.lastGeolocationResponse = lastGeolocationResponse;
        this.cause = cause;
        this.apiVersion = apiVersion;
        this.uri = uri;
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public DateTime getDateExecuted() {
        return this.dateExecuted;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public String getSource() {
        return this.source;
    }

    public String getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public GeolocationType getGeolocationType() {
        return this.geolocationType;
    }

    public String getResponseStatus() {
        return this.responseStatus;
    }

    public String getCellId() {
        return this.cellId;
    }

    public String getLocationAreaCode() {
        return this.locationAreaCode;
    }

    public Integer getMobileCountryCode() {
        return this.mobileCountryCode;
    }

    public String getMobileNetworkCode() {
        return this.mobileNetworkCode;
    }

    public Long getNetworkEntityAddress() {
        return this.networkEntityAddress;
    }

    public Integer getAgeOfLocationInfo() {
        return this.ageOfLocationInfo;
    }

    public String getDeviceLatitude() {
        return this.deviceLatitude;
    }

    public String getDeviceLongitude() {
        return this.deviceLongitude;
    }

    public Long getAccuracy() {
        return this.accuracy;
    }

    public String getPhysicalAddress() {
        return this.physicalAddress;
    }

    public String getInternetAddress() {
        return this.internetAddress;
    }

    public String getFormattedAddress() {
        return this.formattedAddress;
    }

    public DateTime getLocationTimestamp() {
        return this.locationTimestamp;
    }

    public String getEventGeofenceLatitude() {
        return this.eventGeofenceLatitude;
    }

    public String getEventGeofenceLongitude() {
        return this.eventGeofenceLongitude;
    }

    public Long getRadius() {
        return this.radius;
    }

    public String getGeolocationPositioningType() {
        return this.geolocationPositioningType;
    }

    public String getLastGeolocationResponse() {
        return this.lastGeolocationResponse;
    }

    public String getCause() {
        return this.cause;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public URI getUri() {
        return this.uri;
    }

    public Geolocation setSid(Sid sid) {
        return new Geolocation(sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setDateCreated(DateTime dateCreated) {
        return new Geolocation(this.sid, dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setDateUpdated(DateTime dateUpdated) {
        return new Geolocation(this.sid, this.dateCreated, dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setDateExecuted(DateTime dateExecuted) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setAccountSid(Sid accountSid) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setSource(String source) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setDeviceIdentifier(String deviceIdentifier) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setGeolocationType(GeolocationType geolocationType) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setResponseStatus(String responseStatus) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setCellId(String cellId) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setLocationAreaCode(String locationAreaCode) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setLocationTimestamp(DateTime locationTimestamp) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setMobileCountryCode(Integer mobileCountryCode) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setMobileNetworkCode(String mobileNetworkCode) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setNetworkEntityAddress(Long networkEntityAddress) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setAgeOfLocationInfo(Integer ageOfLocationInfo) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setDeviceLatitude(String deviceLatitude) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setDeviceLongitude(String deviceLongitude) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setAccuracy(Long accuracy) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setPhysicalAddress(String physicalAddress) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setInternetAddress(String internetAddress) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setFormattedAddress(String formattedAddress) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setEventGeofenceLatitude(String eventGeofenceLatitude) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setEventGeofenceLongitude(String eventGeofenceLongitude) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setRadius(Long radius) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setGeolocationPositioningType(String geolocationPositioningType) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setLastGeolocationResponse(String lastGeolocationResponse) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
    }

    public Geolocation setCause(String cause) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, cause, this.apiVersion, this.uri);
    }

    public Geolocation setApiVersion(String apiVersion) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, apiVersion, this.uri);
    }

    public Geolocation setUri(URI uri) {
        return new Geolocation(this.sid, this.dateCreated, this.dateUpdated, this.dateExecuted, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, uri);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid;
        private DateTime dateUpdated;
        private Sid accountSid;
        private String source;
        private String deviceIdentifier;
        private GeolocationType geolocationType;
        private String responseStatus;
        private String cellId;
        private String locationAreaCode;
        private Integer mobileCountryCode;
        private String mobileNetworkCode;
        private Long networkEntityAddress;
        private Integer ageOfLocationInfo;
        private String deviceLatitude;
        private String deviceLongitude;
        private Long accuracy;
        private String physicalAddress;
        private String internetAddress;
        private String formattedAddress;
        private DateTime locationTimestamp;
        private String eventGeofenceLatitude;
        private String eventGeofenceLongitude;
        private Long radius;
        private String geolocationPositioningType;
        private String lastGeolocationResponse;
        private String cause;
        private String apiVersion;
        private URI uri;

        private Builder() {
        }

        public Geolocation build() {
            DateTime now = DateTime.now();
            return new Geolocation(this.sid, now, this.dateUpdated, now, this.accountSid, this.source, this.deviceIdentifier, this.geolocationType, this.responseStatus, this.cellId, this.locationAreaCode, this.mobileCountryCode, this.mobileNetworkCode, this.networkEntityAddress, this.ageOfLocationInfo, this.deviceLatitude, this.deviceLongitude, this.accuracy, this.physicalAddress, this.internetAddress, this.formattedAddress, this.locationTimestamp, this.eventGeofenceLatitude, this.eventGeofenceLongitude, this.radius, this.geolocationPositioningType, this.lastGeolocationResponse, this.cause, this.apiVersion, this.uri);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setDateUpdated(DateTime dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setDeviceIdentifier(String deviceIdentifier) {
            this.deviceIdentifier = deviceIdentifier;
        }

        public void setGeolocationType(GeolocationType geolocationType) {
            this.geolocationType = geolocationType;
        }

        public void setResponseStatus(String responseStatus) {
            this.responseStatus = responseStatus;
        }

        public void setCellId(String cellId) {
            this.cellId = cellId;
        }

        public void setLocationAreaCode(String locationAreaCode) {
            this.locationAreaCode = locationAreaCode;
        }

        public void setMobileCountryCode(Integer mobileCountryCode) {
            this.mobileCountryCode = mobileCountryCode;
        }

        public void setMobileNetworkCode(String mobileNetworkCode) {
            this.mobileNetworkCode = mobileNetworkCode;
        }

        public void setNetworkEntityAddress(Long networkEntityAddress) {
            this.networkEntityAddress = networkEntityAddress;
        }

        public void setAgeOfLocationInfo(Integer ageOfLocationInfo) {
            this.ageOfLocationInfo = ageOfLocationInfo;
        }

        public void setDeviceLatitude(String devLatitude) {
            this.deviceLatitude = devLatitude;
        }

        public void setDeviceLongitude(String devLongitude) {
            this.deviceLongitude = devLongitude;
        }

        public void setAccuracy(Long accuracy) {
            this.accuracy = accuracy;
        }

        public void setPhysicalAddress(String physicalAddress) {
            this.physicalAddress = physicalAddress;
        }

        public void setInternetAddress(String internetAddress) {
            this.internetAddress = internetAddress;
        }

        public void setFormattedAddress(String formattedAddress) {
            this.formattedAddress = formattedAddress;
        }

        public void setLocationTimestamp(DateTime locationTimestamp) {
            try {
                this.locationTimestamp = locationTimestamp;
            }
            catch (Exception exception) {
                DateTime locTimestamp;
                this.locationTimestamp = locTimestamp = DateTime.parse((String)"1900-01-01");
            }
        }

        public void setEventGeofenceLatitude(String eventGeofenceLat) {
            this.eventGeofenceLatitude = eventGeofenceLat;
        }

        public void setEventGeofenceLongitude(String eventGeofenceLong) {
            this.eventGeofenceLongitude = eventGeofenceLong;
        }

        public void setRadius(Long radius) {
            this.radius = this.geolocationType.toString().equals((Object)GeolocationType.Notification) ? radius : null;
        }

        public void setGeolocationPositioningType(String geolocationPositioningType) {
            this.geolocationPositioningType = geolocationPositioningType;
        }

        public void setLastGeolocationResponse(String lastGeolocationResponse) {
            this.lastGeolocationResponse = lastGeolocationResponse;
        }

        public void setCause(String cause) {
            if (this.responseStatus != null && (this.responseStatus.equalsIgnoreCase("rejected") || this.responseStatus.equalsIgnoreCase("unauthorized") || this.responseStatus.equalsIgnoreCase("failed"))) {
                this.cause = cause;
            }
            if (!(this.responseStatus == null || this.responseStatus.equalsIgnoreCase("rejected") || this.responseStatus.equalsIgnoreCase("unauthorized") || this.responseStatus.equalsIgnoreCase("failed"))) {
                this.cause = null;
            }
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }

    public static enum GeolocationType {
        Immediate("Immediate"),
        Notification("Notification");

        private final String glt;

        private GeolocationType(String glt) {
            this.glt = glt;
        }

        public static GeolocationType getValueOf(String glt) {
            GeolocationType[] values;
            for (GeolocationType value : values = GeolocationType.values()) {
                if (!value.toString().equals(glt)) continue;
                return value;
            }
            throw new IllegalArgumentException(glt + " is not a valid GeolocationType.");
        }

        public String toString() {
            return this.glt;
        }
    }
}

