/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;

@Immutable
public final class MediaServerEntity {
    private final int msId;
    private final String compatibility;
    private final String localIpAddress;
    private final int localPort;
    private final String remoteIpAddress;
    private final int remotePort;
    private final String responseTimeout;
    private final String externalAddress;

    public MediaServerEntity(int msId, String compatibility, String localIpAddress, int localPort, String remoteIpAddress, int remotePort, String responseTimeout, String externalAddress) {
        this.msId = msId;
        this.compatibility = compatibility;
        this.localIpAddress = localIpAddress;
        this.localPort = localPort;
        this.remoteIpAddress = remoteIpAddress;
        this.remotePort = remotePort;
        this.responseTimeout = responseTimeout;
        this.externalAddress = externalAddress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMsId() {
        return this.msId;
    }

    public String getCompatibility() {
        return this.compatibility;
    }

    public String getLocalIpAddress() {
        return this.localIpAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getRemoteIpAddress() {
        return this.remoteIpAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getResponseTimeout() {
        return this.responseTimeout;
    }

    public String getExternalAddress() {
        return this.externalAddress;
    }

    public MediaServerEntity setMsId(int msId) {
        return new MediaServerEntity(msId, this.compatibility, this.localIpAddress, this.localPort, this.remoteIpAddress, this.remotePort, this.responseTimeout, this.externalAddress);
    }

    @NotThreadSafe
    public static final class Builder {
        private int msId;
        private String compatibility = null;
        private String localIpAddress = null;
        private int localPort;
        private String remoteIpAddress = null;
        private int remotePort;
        private String responseTimeout = null;
        private String externalAddress = null;

        private Builder() {
        }

        public MediaServerEntity build() {
            return new MediaServerEntity(this.msId, this.compatibility, this.localIpAddress, this.localPort, this.remoteIpAddress, this.remotePort, this.responseTimeout, this.externalAddress);
        }

        public void setMsId(int msId) {
            this.msId = msId;
        }

        public void setCompatibility(String compatibility) {
            this.compatibility = compatibility;
        }

        public void setLocalIpAddress(String localIpAddress) {
            this.localIpAddress = localIpAddress;
        }

        public void setLocalPort(int localPort) {
            this.localPort = localPort;
        }

        public void setRemoteIpAddress(String remoteIpAddress) {
            this.remoteIpAddress = remoteIpAddress;
        }

        public void setRemotePort(int remotePort) {
            this.remotePort = remotePort;
        }

        public void setResponseTimeout(String responseTimeout) {
            this.responseTimeout = responseTimeout;
        }

        public void setExternalAddress(String externalAddress) {
            this.externalAddress = externalAddress;
        }
    }
}

