/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.net.URI;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;

@Immutable
public final class Notification {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Sid accountSid;
    private final Sid callSid;
    private final String apiVersion;
    private final Integer log;
    private final Integer errorCode;
    private final URI moreInfo;
    private final String messageText;
    private final DateTime messageDate;
    private final URI requestUrl;
    private final String requestMethod;
    private final String requestVariables;
    private final String responseHeaders;
    private final String responseBody;
    private final URI uri;

    public Notification(Sid sid, DateTime dateCreated, DateTime dateUpdated, Sid accountSid, Sid callSid, String apiVersion, Integer log, Integer errorCode, URI moreInfo, String messageText, DateTime messageDate, URI requestUrl, String requestMethod, String requestVariables, String responseHeaders, String responseBody, URI uri) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.apiVersion = apiVersion;
        this.log = log;
        this.errorCode = errorCode;
        this.moreInfo = moreInfo;
        this.messageText = messageText;
        this.messageDate = messageDate;
        this.requestUrl = requestUrl;
        this.requestMethod = requestMethod;
        this.requestVariables = requestVariables;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public Sid getCallSid() {
        return this.callSid;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Integer getLog() {
        return this.log;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public URI getMoreInfo() {
        return this.moreInfo;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public DateTime getMessageDate() {
        return this.messageDate;
    }

    public URI getRequestUrl() {
        return this.requestUrl;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestVariables() {
        return this.requestVariables;
    }

    public String getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public URI getUri() {
        return this.uri;
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid;
        private Sid accountSid;
        private Sid callSid;
        private String apiVersion;
        private Integer log;
        private Integer errorCode;
        private URI moreInfo;
        private String messageText;
        private DateTime messageDate;
        private URI requestUrl;
        private String requestMethod;
        private String requestVariables;
        private String responseHeaders;
        private String responseBody;
        private URI uri;

        private Builder() {
        }

        public Notification build() {
            DateTime now = DateTime.now();
            return new Notification(this.sid, now, now, this.accountSid, this.callSid, this.apiVersion, this.log, this.errorCode, this.moreInfo, this.messageText, this.messageDate, this.requestUrl, this.requestMethod, this.requestVariables, this.responseHeaders, this.responseBody, this.uri);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setCallSid(Sid callSid) {
            this.callSid = callSid;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setLog(int log) {
            this.log = log;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public void setMoreInfo(URI moreInfo) {
            this.moreInfo = moreInfo;
        }

        public void setMessageText(String messageText) {
            this.messageText = messageText;
        }

        public void setMessageDate(DateTime messageDate) {
            this.messageDate = messageDate;
        }

        public void setRequestUrl(URI requestUrl) {
            this.requestUrl = requestUrl;
        }

        public void setRequestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
        }

        public void setRequestVariables(String requestVariables) {
            this.requestVariables = requestVariables;
        }

        public void setResponseHeaders(String responseHeaders) {
            this.responseHeaders = responseHeaders;
        }

        public void setResponseBody(String responseBody) {
            this.responseBody = responseBody;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }
}

