/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class RecordingFilter {
    private final String accountSid;
    private final List<String> accountSidSet;
    private final Date startTime;
    private final Date endTime;
    private final String callSid;
    private final Integer limit;
    private final Integer offset;
    private final String instanceid;

    public RecordingFilter(String accountSid, List<String> accountSidSet, String startTime, String endTime, String callSid, Integer limit, Integer offset) throws ParseException {
        this(accountSid, accountSidSet, startTime, endTime, callSid, limit, offset, null);
    }

    public RecordingFilter(String accountSid, List<String> accountSidSet, String startTime, String endTime, String callSid, Integer limit, Integer offset, String instanceId) throws ParseException {
        Date date;
        SimpleDateFormat parser;
        this.accountSid = accountSid;
        this.accountSidSet = accountSidSet;
        this.callSid = callSid;
        this.limit = limit;
        this.offset = offset;
        if (startTime != null) {
            parser = new SimpleDateFormat("yyyy-MM-dd");
            this.startTime = date = parser.parse(startTime);
        } else {
            this.startTime = null;
        }
        if (endTime != null) {
            parser = new SimpleDateFormat("yyyy-MM-dd");
            this.endTime = date = parser.parse(endTime);
        } else {
            this.endTime = null;
        }
        this.instanceid = instanceId != null && !instanceId.isEmpty() ? instanceId : null;
    }

    public String getSid() {
        return this.accountSid;
    }

    public List<String> getAccountSidSet() {
        return this.accountSidSet;
    }

    public String getCallSid() {
        return this.callSid;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getInstanceid() {
        return this.instanceid;
    }
}

