/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.dao.Sid;

@Immutable
public final class Registration
implements Comparable<Registration> {
    private final Sid sid;
    private final String instanceId;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime dateExpires;
    private final String addressOfRecord;
    private final String displayName;
    private final String userName;
    private final int timeToLive;
    private final String location;
    private final String userAgent;
    private final boolean webrtc;
    private final boolean isLBPresent;

    public Registration(Sid sid, String instanceId, DateTime dateCreated, DateTime dateUpdated, String addressOfRecord, String displayName, String userName, String userAgent, int timeToLive, String location, boolean webRTC, boolean isLBPresent) {
        this(sid, instanceId, dateCreated, dateUpdated, DateTime.now().plusSeconds(timeToLive), addressOfRecord, displayName, userName, userAgent, timeToLive, location, webRTC, isLBPresent);
    }

    public Registration(Sid sid, String instanceId, DateTime dateCreated, DateTime dateUpdated, DateTime dateExpires, String addressOfRecord, String displayName, String userName, String userAgent, int timeToLive, String location, boolean webRTC, boolean isLBPresent) {
        this.sid = sid;
        this.instanceId = instanceId;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.dateExpires = dateExpires;
        this.addressOfRecord = addressOfRecord;
        this.displayName = displayName;
        this.userName = userName;
        this.location = location;
        this.userAgent = userAgent;
        this.timeToLive = timeToLive;
        this.webrtc = webRTC;
        this.isLBPresent = isLBPresent;
    }

    public Sid getSid() {
        return this.sid;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public DateTime getDateExpires() {
        return this.dateExpires;
    }

    public String getAddressOfRecord() {
        return this.addressOfRecord;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isWebRTC() {
        return this.webrtc;
    }

    public boolean isLBPresent() {
        return this.isLBPresent;
    }

    public Registration setTimeToLive(int timeToLive) {
        DateTime now = DateTime.now();
        return new Registration(this.sid, this.instanceId, this.dateCreated, now, now.plusSeconds(timeToLive), this.addressOfRecord, this.displayName, this.userName, this.userAgent, timeToLive, this.location, this.webrtc, this.isLBPresent);
    }

    public Registration updated() {
        DateTime now = DateTime.now();
        return new Registration(this.sid, this.instanceId, this.dateCreated, now, this.dateExpires, this.addressOfRecord, this.displayName, this.userName, this.userAgent, this.timeToLive, this.location, this.webrtc, this.isLBPresent);
    }

    @Override
    public int compareTo(Registration registration) {
        if (this.getDateUpdated().toDate().getTime() > registration.getDateUpdated().toDate().getTime()) {
            return -1;
        }
        return 1;
    }
}

