/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;

@Immutable
public final class Transcription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Sid accountSid;
    private final Status status;
    private final Sid recordingSid;
    private final Double duration;
    private final String transcriptionText;
    private final BigDecimal price;
    private Currency priceUnit;
    private final URI uri;

    public Transcription(Sid sid, DateTime dateCreated, DateTime dateUpdated, Sid accountSid, Status status, Sid recordingSid, Double duration, String transcriptionText, BigDecimal price, Currency priceUnit, URI uri) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.accountSid = accountSid;
        this.status = status;
        this.recordingSid = recordingSid;
        this.duration = duration;
        this.transcriptionText = transcriptionText;
        this.price = price;
        this.priceUnit = priceUnit;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public Status getStatus() {
        return this.status;
    }

    public Sid getRecordingSid() {
        return this.recordingSid;
    }

    public Double getDuration() {
        return this.duration;
    }

    public String getTranscriptionText() {
        return this.transcriptionText;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Currency getPriceUnit() {
        return this.priceUnit;
    }

    public URI getUri() {
        return this.uri;
    }

    public Transcription setStatus(Status status) {
        DateTime now = DateTime.now();
        return new Transcription(this.sid, this.dateCreated, now, this.accountSid, status, this.recordingSid, this.duration, this.transcriptionText, this.price, this.priceUnit, this.uri);
    }

    public Transcription setTranscriptionText(String text) {
        DateTime now = DateTime.now();
        return new Transcription(this.sid, this.dateCreated, now, this.accountSid, this.status, this.recordingSid, this.duration, text, this.price, this.priceUnit, this.uri);
    }

    public static enum Status {
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        FAILED("failed");

        private final String text;

        private Status(String text) {
            this.text = text;
        }

        public static Status getStatusValue(String text) {
            Status[] values;
            for (Status value : values = Status.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid status.");
        }

        public String toString() {
            return this.text;
        }
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid;
        private Sid accountSid;
        private Status status;
        private Sid recordingSid;
        private Double duration;
        private String transcriptionText;
        private BigDecimal price;
        private Currency priceUnit;
        private URI uri;

        private Builder() {
        }

        public Transcription build() {
            DateTime now = DateTime.now();
            return new Transcription(this.sid, now, now, this.accountSid, this.status, this.recordingSid, this.duration, this.transcriptionText, this.price, this.priceUnit, this.uri);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setRecordingSid(Sid recordingSid) {
            this.recordingSid = recordingSid;
        }

        public void setDuration(double duration) {
            this.duration = duration;
        }

        public void setTranscriptionText(String transcriptionText) {
            this.transcriptionText = transcriptionText;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public void setPriceUnit(Currency priceUnit) {
            this.priceUnit = priceUnit;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }
}

