/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;

@Immutable
public class TranscriptionFilter {
    private final String accountSid;
    private final List<String> accountSidSet;
    private final Date startTime;
    private final Date endTime;
    private final String transcriptionText;
    private final Integer limit;
    private final Integer offset;
    private final String instanceid;

    public TranscriptionFilter(String accountSid, List<String> accountSidSet, String startTime, String endTime, String transcriptionText, Integer limit, Integer offset) throws ParseException {
        this(accountSid, accountSidSet, startTime, endTime, transcriptionText, limit, offset, null);
    }

    public TranscriptionFilter(String accountSid, List<String> accountSidSet, String startTime, String endTime, String transcriptionText, Integer limit, Integer offset, String instanceId) throws ParseException {
        Date date;
        SimpleDateFormat parser;
        this.accountSid = accountSid;
        this.accountSidSet = accountSidSet;
        this.transcriptionText = transcriptionText;
        this.limit = limit;
        this.offset = offset;
        if (startTime != null) {
            parser = new SimpleDateFormat("yyyy-MM-dd");
            this.startTime = date = parser.parse(startTime);
        } else {
            this.startTime = null;
        }
        if (endTime != null) {
            parser = new SimpleDateFormat("yyyy-MM-dd");
            this.endTime = date = parser.parse(endTime);
        } else {
            this.endTime = null;
        }
        this.instanceid = instanceId != null && !instanceId.isEmpty() ? instanceId : null;
    }

    public String getSid() {
        return this.accountSid;
    }

    public List<String> getAccountSidSet() {
        return this.accountSidSet;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getTranscriptionText() {
        return this.transcriptionText;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getInstanceid() {
        return this.instanceid;
    }
}

